/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.fabric.integration.rei;

import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_1058;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.lib.ResourceLocationHelper;

import java.util.ArrayList;
import java.util.List;

public class ElvenTradeREICategory implements DisplayCategory<ElvenTradeREIDisplay> {
	private final EntryStack<class_1799> gateway = EntryStacks.of(new class_1799(BotaniaBlocks.alfPortal));
	private final class_2960 TRADE_OVERLAY = ResourceLocationHelper.prefix("textures/gui/elven_trade_overlay.png");

	@Override
	public @NotNull CategoryIdentifier<ElvenTradeREIDisplay> getCategoryIdentifier() {
		return BotaniaREICategoryIdentifiers.ELVEN_TRADE;
	}

	@Override
	public @NotNull Renderer getIcon() {
		return gateway;
	}

	@Override
	public @NotNull class_2561 getTitle() {
		return class_2561.method_43471("botania.nei.elvenTrade");
	}

	@Override
	public @NotNull List<Widget> setupDisplay(ElvenTradeREIDisplay display, Rectangle bounds) {
		List<Widget> widgets = new ArrayList<>();
		Point center = new Point(bounds.getCenterX() - 8, bounds.getCenterY() - 4);
		widgets.add(Widgets.createRecipeBase(bounds));
		widgets.add(Widgets.createDrawableWidget((gui, mouseX, mouseY, delta) -> {
			CategoryUtils.drawOverlay(gui, TRADE_OVERLAY, center.x - 45, center.y - 34, 20, 19, 71, 75);
			drawPortal(gui.method_51448(), center);
		}));
		int x = center.x - 20;
		for (EntryIngredient o : display.getInputEntries()) {
			widgets.add(Widgets.createSlot(new Point(x, center.y - 40)).entries(o).disableBackground());
			x += 18;
		}
		x = center.x + 28;
		for (EntryIngredient o : display.getOutputEntries()) {
			widgets.add(Widgets.createSlot(new Point(x, center.y)).entries(o).disableBackground());
			x += 18;
		}
		return widgets;
	}

	@Override
	public int getDisplayHeight() {
		return 100;
	}

	void drawPortal(class_4587 matrices, Point point) {
		class_1058 sprite = class_310.method_1551().method_1549(class_1723.field_21668).apply(ResourceLocationHelper.prefix("block/alfheim_portal_swirl"));
		class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
		class_4588 v = immediate.getBuffer(class_1921.method_23577());
		int startX = point.x - 43;
		int startY = point.y - 17;
		int stopX = startX + 48;
		int stopY = startY + 48;
		Matrix4f mat = matrices.method_23760().method_23761();
		Matrix3f n = matrices.method_23760().method_23762();
		v.method_22918(mat, startX, startY, 0).method_22915(1f, 1f, 1f, 1f).method_22913(sprite.method_4594(), sprite.method_4593()).method_22916(0xF000F0).method_23763(n, 1, 0, 0).method_1344();
		v.method_22918(mat, startX, stopY, 0).method_22915(1f, 1f, 1f, 1f).method_22913(sprite.method_4594(), sprite.method_4575()).method_22916(0xF000F0).method_23763(n, 1, 0, 0).method_1344();
		v.method_22918(mat, stopX, stopY, 0).method_22915(1f, 1f, 1f, 1f).method_22913(sprite.method_4577(), sprite.method_4575()).method_22916(0xF000F0).method_23763(n, 1, 0, 0).method_1344();
		v.method_22918(mat, stopX, startY, 0).method_22915(1f, 1f, 1f, 1f).method_22913(sprite.method_4577(), sprite.method_4593()).method_22916(0xF000F0).method_23763(n, 1, 0, 0).method_1344();
		immediate.method_22993();
	}
}
