/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.helper;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.block.block_entity.SimpleInventoryBlockEntity;
import vazkii.botania.mixin.HopperBlockEntityAccessor;
import vazkii.botania.mixin.InventoryAccessor;

import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2614;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5712;

public class InventoryHelper {

	// [VanillaCopy] HopperBlockEntity#transfer but simulates instead of doing it
	public static class_1799 simulateTransfer(class_1263 to, class_1799 stack, @Nullable class_2350 side) {
		stack = stack.method_7972();

		if (to instanceof class_1278 sidedInventory && side != null) {
			int[] is = sidedInventory.method_5494(side);

			for (int i = 0; i < is.length && !stack.method_7960(); ++i) {
				stack = simulateTransfer(to, stack, is[i], side);
			}
		} else {
			int j = to.method_5439();

			for (int k = 0; k < j && !stack.method_7960(); ++k) {
				stack = simulateTransfer(to, stack, k, side);
			}
		}

		return stack;
	}

	// [VanillaCopy] HopperBlockEntity without modifying the destination inventory. `stack` is still modified
	private static class_1799 simulateTransfer(class_1263 to, class_1799 stack, int slot, @Nullable class_2350 direction) {
		class_1799 itemStack = to.method_5438(slot);
		if (HopperBlockEntityAccessor.botania_canInsert(to, stack, slot, direction)) {
			boolean bl = false;
			boolean bl2 = to.method_5442();
			if (itemStack.method_7960()) {
				// to.setStack(slot, stack);
				stack = class_1799.field_8037;
				bl = true;
			} else if (HopperBlockEntityAccessor.botania_canMerge(itemStack, stack)) {
				int i = stack.method_7914() - itemStack.method_7947();
				int j = Math.min(stack.method_7947(), i);
				stack.method_7934(j);
				// itemStack.increment(j);
				bl = j > 0;
			}

			/*
			if (bl) {
				if (bl2 && to instanceof HopperBlockEntity) {
					HopperBlockEntity hopperBlockEntity = (HopperBlockEntity)to;
					if (!hopperBlockEntity.isDisabled()) {
						int k = 0;
						if (from instanceof HopperBlockEntity) {
							HopperBlockEntity hopperBlockEntity2 = (HopperBlockEntity)from;
							if (hopperBlockEntity.lastTickTime >= hopperBlockEntity2.lastTickTime) {
								k = 1;
							}
						}
			
						hopperBlockEntity.setCooldown(8 - k);
					}
				}
			
				to.markDirty();
			}
			*/
		}

		return stack;
	}

	public static void withdrawFromInventory(SimpleInventoryBlockEntity inv, class_1657 player) {
		for (int i = inv.inventorySize() - 1; i >= 0; i--) {
			class_1799 stackAt = inv.getItemHandler().method_5438(i);
			if (!stackAt.method_7960()) {
				class_1799 copy = stackAt.method_7972();
				player.method_31548().method_7398(copy);
				inv.getItemHandler().method_5447(i, class_1799.field_8037);
				inv.method_10997().method_33596(null, class_5712.field_28733, inv.method_11016());
				break;
			}
		}
	}

	public static boolean overrideStackedOnOther(
			Function<class_1799, class_1263> inventoryGetter,
			boolean selfGuiOpen,
			@NotNull class_1799 container, @NotNull class_1735 slot,
			@NotNull class_5536 clickAction, @NotNull class_1657 player) {
		if (!selfGuiOpen && clickAction == class_5536.field_27014) {
			class_1799 toInsert = slot.method_7677();
			var inventory = inventoryGetter.apply(container);
			if (simulateTransfer(inventory, toInsert, null).method_7960()) {
				class_1799 taken = slot.method_32753(toInsert.method_7947(), Integer.MAX_VALUE, player);
				class_2614.method_11260(null, inventory, taken, null);
				return true;
			}
		}
		return false;
	}

	public static boolean overrideOtherStackedOnMe(
			Function<class_1799, class_1263> inventoryGetter,
			boolean selfGuiOpen,
			@NotNull class_1799 container, @NotNull class_1799 toInsert,
			@NotNull class_5536 clickAction, @NotNull class_5630 cursorAccess) {
		if (!selfGuiOpen && clickAction == class_5536.field_27014) {
			var inventory = inventoryGetter.apply(container);
			if (simulateTransfer(inventory, toInsert, null).method_7960()) {
				class_2614.method_11260(null, inventory, toInsert, null);
				cursorAccess.method_32332(class_1799.field_8037);
				return true;
			}
		}
		return false;
	}

	public static void checkEmpty(class_1799 remainder) {
		if (!remainder.method_7960()) {
			BotaniaAPI.LOGGER.warn("Remainder was not empty after insert, item may have been lost: {}", remainder);
		}
	}

	public static boolean tryToSetLastRecipe(class_1657 player, class_1263 inv, @Nullable List<class_1799> lastRecipe, @Nullable class_3414 sound) {
		if (lastRecipe == null || lastRecipe.isEmpty()) {
			return false;
		}

		int index = 0;
		boolean didAny = false;
		for (class_1799 stack : lastRecipe) {
			if (stack.method_7960()) {
				continue;
			}

			for (int i = 0; i < player.method_31548().method_5439(); i++) {
				class_1799 pstack = player.method_31548().method_5438(i);
				if (player.method_7337() || (!pstack.method_7960() && class_1799.method_31577(stack, pstack))) {
					inv.method_5447(index, player.method_7337() ? stack.method_7972() : pstack.method_7971(1));
					didAny = true;
					index++;
					break;
				}
			}
		}

		if (didAny) {
			if (sound != null) {
				player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), sound, class_3419.field_15245, 0.1F, 10F);
			}
			class_3222 mp = (class_3222) player;
			mp.field_7498.method_7623();
		}
		return didAny;
	}

	/**
	 * Replicates pre-1.20 behavior of {@link class_1661#method_7379(class_1799)}, i.e. only matching item type.
	 * 
	 * @param inventory The Inventory.
	 * @param item      The item to match.
	 * @return {@code true} if the inventory contains an item of the specified type, otherwise {@code false}.
	 */
	public static boolean containsType(class_1661 inventory, class_1792 item) {
		for (List<class_1799> compartment : ((InventoryAccessor) inventory).getCompartments()) {
			for (class_1799 stack : compartment) {
				if (stack.method_31574(item)) {
					return true;
				}
			}
		}

		return false;
	}
}
