/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.handler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableList.Builder;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.recipe.OrechidRecipe;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.*;
import java.util.function.ToIntFunction;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3956;
import net.minecraft.class_4013;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class OrechidManager implements class_4013 {
	private static final Map<class_3956<? extends OrechidRecipe>, Map<class_2680, List<? extends OrechidRecipe>>> BY_TYPE = new IdentityHashMap<>();
	private static final Map<class_3956<? extends OrechidRecipe>, Object2IntOpenHashMap<class_2680>> TOTAL_WEIGHTS_WITHOUT_POSITION = new IdentityHashMap<>();

	public static void registerListener() {
		XplatAbstractions.INSTANCE.registerReloadListener(class_3264.field_14190, prefix("orechid"), new OrechidManager());
	}

	@Override
	public void method_14491(@NotNull class_3300 manager) {
		BY_TYPE.clear();
		TOTAL_WEIGHTS_WITHOUT_POSITION.clear();
	}

	public static <T extends OrechidRecipe> Collection<T> getMatchingRecipes(
			class_1863 manager,
			class_3956<T> type,
			class_2680 state) {
		final var byState = BY_TYPE.computeIfAbsent(type, t -> new IdentityHashMap<>());
		final var list = byState.computeIfAbsent(state, s -> {
			var builder = ImmutableList.<T>builder();
			for (var recipe : manager.method_30027(type)) {
				if (recipe.getInput().test(state)) {
					builder.add(recipe);
				}
			}
			return builder.build();
		});

		@SuppressWarnings("unchecked") // we only add T's to this list in the above loop
		List<T> result = (List<T>) list;
		return result;
	}

	public static int getTotalDisplayWeightAt(class_1937 level, class_3956<? extends OrechidRecipe> type, class_2680 state, @Nullable class_2338 pos) {
		return pos == null
				? getCachedTotalDisplayWeightWithoutPosition(level, type, state)
				: calculateTotalDisplayWeightAtPosition(level, type, state, pos);
	}

	private static int getCachedTotalDisplayWeightWithoutPosition(class_1937 level, class_3956<? extends OrechidRecipe> type, class_2680 state) {
		final var byState = TOTAL_WEIGHTS_WITHOUT_POSITION.computeIfAbsent(type, t -> new Object2IntOpenHashMap<>());
		return byState.computeIfAbsent(state, s -> calculateTotalDisplayWeightAtPosition(level, type, state, null));
	}

	private static int calculateTotalDisplayWeightAtPosition(class_1937 level, class_3956<? extends OrechidRecipe> type, class_2680 state, @Nullable class_2338 pos) {
		final var recipeList = getMatchingRecipes(level.method_8433(), type, state);
		if (recipeList.isEmpty()) {
			return 0;
		}

		ToIntFunction<OrechidRecipe> weightFunction = pos != null
				? r -> r.getWeight(level, pos)
				: OrechidRecipe::getWeight;
		return recipeList.stream().mapToInt(weightFunction).sum();
	}

}
