/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.block_entity.mana;

import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntity;

public class SpreaderTurntableBlockEntity extends BotaniaBlockEntity implements Wandable {
	private static final String TAG_SPEED = "speed";
	private static final String TAG_BACKWARDS = "backwards";

	private int speed = 1;
	private boolean backwards = false;

	public SpreaderTurntableBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaBlockEntities.TURNTABLE, pos, state);
	}

	public static void commonTick(class_1937 level, class_2338 worldPosition, class_2680 state, SpreaderTurntableBlockEntity self) {
		if (!level.method_49803(worldPosition)) {
			class_2586 tile = level.method_8321(worldPosition.method_10084());
			if (tile instanceof ManaSpreaderBlockEntity spreader) {
				spreader.rotationX += self.speed * (self.backwards ? -1 : 1);
				if (spreader.rotationX >= 360F) {
					spreader.rotationX -= 360F;
				}
				if (!level.field_9236) {
					spreader.checkForReceiver();
				}
			}
		}
	}

	@Override
	public void writePacketNBT(class_2487 cmp) {
		cmp.method_10569(TAG_SPEED, speed);
		cmp.method_10556(TAG_BACKWARDS, backwards);
	}

	@Override
	public void readPacketNBT(class_2487 cmp) {
		speed = cmp.method_10550(TAG_SPEED);
		backwards = cmp.method_10577(TAG_BACKWARDS);
	}

	@Override
	public boolean onUsedByWand(@Nullable class_1657 player, class_1799 wand, class_2350 side) {
		if ((player != null && player.method_5715()) || (player == null && side == class_2350.field_11033)) {
			backwards = !backwards;
		} else {
			speed = speed == 6 ? 1 : speed + 1;
		}
		VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
		return true;
	}

	public static class WandHud implements WandHUD {
		private final SpreaderTurntableBlockEntity turntable;

		public WandHud(SpreaderTurntableBlockEntity turntable) {
			this.turntable = turntable;
		}

		@Override
		public void renderHUD(class_332 gui, class_310 mc) {
			char motion = turntable.backwards ? '<' : '>';
			String speed = class_124.field_1067 + "";
			for (int i = 0; i < turntable.speed; i++) {
				speed = speed + motion;
			}

			int strWidth = mc.field_1772.method_1727(speed);
			int x = (mc.method_22683().method_4486() - strWidth) / 2;
			int y = mc.method_22683().method_4502() / 2 + 8;

			RenderHelper.renderHUDBox(gui, x - 2, y, x + strWidth + 2, y + 12);
			gui.method_25303(mc.field_1772, speed, x, y + 2, class_124.field_1068.method_532());
		}
	}

}
