/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.ForcePushHelper;
import vazkii.botania.common.item.WandOfTheForestItem;
import vazkii.botania.common.item.lens.ForceLens;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.BotaniaEffectPacket;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.*;
import java.util.Map.Entry;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2667;
import net.minecraft.class_2680;
import net.minecraft.class_2764;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3619;
import net.minecraft.class_4208;

public class ForceRelayBlock extends BotaniaBlock {

	public final Map<UUID, class_4208> activeBindingAttempts = new HashMap<>();

	public ForceRelayBlock(class_2251 builder) {
		super(builder.method_50012(class_3619.field_15970));
	}

	@Override
	public void method_9536(@NotNull class_2680 state, @NotNull class_1937 world, @NotNull class_2338 pos, @NotNull class_2680 newState, boolean isMoving) {
		if (!world.field_9236) {
			var data = WorldData.get(world);

			class_2350 movementContextDirection = ForcePushHelper.getMovementContextDirection();
			if (isMoving && (movementContextDirection != null || newState.method_27852(class_2246.field_10008))) {
				var pistonDirection = movementContextDirection != null
						? movementContextDirection
						: newState.method_11654(class_2667.field_12196);
				// if being moved as part of a retracting sticky piston's block structure, reverse movement direction
				var moveDirection = ForcePushHelper.isExtendingMovementContext() ? pistonDirection : pistonDirection.method_10153();

				var destPos = data.mapping.get(pos);
				if (destPos != null) {
					class_2338 newSrcPos = pos.method_10093(moveDirection);

					{
						// Move source side of our binding along
						data.mapping.remove(pos);
						data.mapping.put(newSrcPos, destPos);
						data.method_80();
					}

					if (!newState.method_27852(class_2246.field_10008) || newState.method_11654(class_2667.field_12197) == class_2764.field_12637) {
						// Move the actual bound blocks
						if (ForceLens.moveBlocks(world, destPos.method_10093(moveDirection.method_10153()), moveDirection, pos)) {
							// Move dest side of our binding
							data.mapping.put(newSrcPos, data.mapping.get(newSrcPos).method_10093(moveDirection));
						}
					}
				}
			} else {
				if (data.mapping.remove(pos) != null) {
					data.method_80();
				}
			}
		}
	}

	public boolean onUsedByWand(class_1657 player, class_1799 stack, class_1937 world, class_2338 pos) {
		if (world.field_9236) {
			return false;
		}

		if (player == null || player.method_5715()) {
			world.method_22352(pos, true);
		} else {
			class_4208 clicked = class_4208.method_19443(world.method_27983(), pos.method_10062());
			if (WandOfTheForestItem.getBindMode(stack)) {
				activeBindingAttempts.put(player.method_5667(), clicked);
				world.method_8396(null, pos, BotaniaSounds.ding, class_3419.field_15245, 0.5F, 1F);
			} else {
				var data = WorldData.get(world);
				if (XplatAbstractions.INSTANCE.isDevEnvironment()) {
					BotaniaAPI.LOGGER.info("PistonRelay pairs");
					for (var e : data.mapping.entrySet()) {
						BotaniaAPI.LOGGER.info("{} -> {}", e.getKey(), e.getValue());
					}
				}
				class_2338 dest = data.mapping.get(pos);
				if (dest != null) {
					XplatAbstractions.INSTANCE.sendToNear(world, pos, new BotaniaEffectPacket(EffectType.PARTICLE_BEAM,
							pos.method_10263() + 0.5, pos.method_10264() + 0.5, pos.method_10260() + 0.5,
							dest.method_10263(), dest.method_10264(), dest.method_10260()));
				}
			}
		}

		return true;
	}

	public static class WorldData extends class_18 {

		private static final String ID = "PistonRelayPairs";
		public final Map<class_2338, class_2338> mapping = new HashMap<>();

		public WorldData(@NotNull class_2487 cmp) {
			class_2499 list = cmp.method_10554("list", class_2520.field_33261);
			for (int i = 0; i < list.size(); i += 2) {
				class_2520 from = list.method_10534(i);
				class_2520 to = list.method_10534(i + 1);
				class_2338 fromPos = class_2338.field_25064.decode(class_2509.field_11560, from).result().get().getFirst();
				class_2338 toPos = class_2338.field_25064.decode(class_2509.field_11560, to).result().get().getFirst();

				mapping.put(fromPos, toPos);
			}
		}

		@NotNull
		@Override
		public class_2487 method_75(@NotNull class_2487 cmp) {
			class_2499 list = new class_2499();
			for (Map.Entry<class_2338, class_2338> e : mapping.entrySet()) {
				class_2520 from = class_2338.field_25064.encodeStart(class_2509.field_11560, e.getKey()).result().get();
				class_2520 to = class_2338.field_25064.encodeStart(class_2509.field_11560, e.getValue()).result().get();
				list.add(from);
				list.add(to);
			}
			cmp.method_10566("list", list);
			return cmp;
		}

		public static WorldData get(class_1937 world) {
			WorldData data = ((class_3218) world).method_17983().method_20786(WorldData::new, ID);
			if (data == null) {
				data = new WorldData(new class_2487());
				data.method_80();
				((class_3218) world).method_17983().method_123(ID, data);
			}
			return data;
		}
	}
}
