/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.entity;

import net.minecraft.class_1723;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_897;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.entity.ManaStormEntity;

public class ManaStormRenderer extends class_897<ManaStormEntity> {

	public ManaStormRenderer(class_5617.class_5618 ctx) {
		super(ctx);
	}

	@Override
	public void render(ManaStormEntity storm, float yaw, float pticks, class_4587 ms, class_4597 buffers, int light) {
		ms.method_22903();
		float maxScale = 1.95F;
		float scale = 0.05F + ((float) storm.burstsFired / ManaStormEntity.TOTAL_BURSTS - (storm.deathTime == 0 ? 0 : storm.deathTime + pticks) / ManaStormEntity.DEATH_TIME) * maxScale;
		RenderHelper.renderStar(ms, buffers, 0x00FF00, scale, scale, scale, storm.method_5667().getMostSignificantBits());
		ms.method_22909();
	}

	@NotNull
	@Override
	public class_2960 getTextureLocation(@NotNull ManaStormEntity entity) {
		return class_1723.field_21668;
	}

}
