/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.patchouli.processor;

import vazkii.botania.api.recipe.TerrestrialAgglomerationRecipe;
import vazkii.botania.client.patchouli.PatchouliUtils;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

import java.util.List;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2960;

public class TerraPlateProcessor implements IComponentProcessor {
	private TerrestrialAgglomerationRecipe recipe;

	@Override
	public void setup(class_1937 level, IVariableProvider variables) {
		class_2960 id = new class_2960(variables.get("recipe").asString());
		this.recipe = PatchouliUtils.getRecipe(level, BotaniaRecipeTypes.TERRA_PLATE_TYPE, id);
	}

	@Override
	public IVariable process(class_1937 level, String key) {
		if (recipe == null) {
			return null;
		}
		if (key.equals("output")) {
			return IVariable.from(recipe.method_8110(level.method_30349()));
		}
		if (key.startsWith("input")) {
			int index = Integer.parseInt(key.substring(5)) - 1;
			List<class_1856> list = recipe.method_8117();
			if (index >= 0 && index < list.size()) {
				return IVariable.from(list.get(index).method_8105());
			}
		}
		return null;
	}
}
