/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.core.helper;

import vazkii.botania.network.TriConsumer;
import vazkii.botania.xplat.BotaniaConfig;

import java.util.function.Consumer;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_5944;
import net.minecraft.class_757;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class CoreShaders {
	private static class_5944 starfieldShaderInstance;
	private static class_5944 doppleganger;
	private static class_5944 manaPool;
	private static class_5944 terraPlate;
	private static class_5944 enchanter;
	private static class_5944 pylon;
	private static class_5944 halo;
	private static class_5944 filmGrainParticle;
	private static class_5944 dopplegangerBar;

	// This is abstracted this way instead of just directly constructing the ShaderInstance
	// Because Fabric is cute and hides the ResourceProvider from modders (why?)
	public static void init(TriConsumer<class_2960, class_293, Consumer<class_5944>> registrations) {
		registrations.accept(
				prefix("starfield"),
				class_290.field_1592,
				inst -> starfieldShaderInstance = inst
		);
		registrations.accept(
				prefix("doppleganger"),
				class_290.field_1580,
				inst -> doppleganger = inst
		);
		registrations.accept(
				prefix("mana_pool"),
				class_290.field_20888,
				inst -> manaPool = inst
		);
		registrations.accept(
				prefix("terra_plate_rune"),
				class_290.field_20888,
				inst -> terraPlate = inst
		);
		registrations.accept(
				prefix("enchanter_rune"),
				class_290.field_20888,
				inst -> enchanter = inst
		);
		registrations.accept(
				prefix("pylon"),
				class_290.field_1580,
				inst -> pylon = inst
		);
		registrations.accept(
				prefix("halo"),
				class_290.field_20887,
				inst -> halo = inst
		);
		registrations.accept(
				prefix("film_grain_particle"),
				class_290.field_1584,
				inst -> filmGrainParticle = inst
		);
		registrations.accept(
				prefix("doppleganger_bar"),
				class_290.field_1585,
				inst -> dopplegangerBar = inst
		);
	}

	public static class_5944 starfield() {
		// Intended to not respect useShaders config. The render kind of relies entirely
		// on the shader, like the end portal.
		return starfieldShaderInstance;
	}

	public static class_5944 doppleganger() {
		if (BotaniaConfig.client().useShaders()) {
			return doppleganger;
		} else {
			return class_757.method_34508();
		}
	}

	public static class_5944 manaPool() {
		if (BotaniaConfig.client().useShaders()) {
			return manaPool;
		} else {
			return class_757.method_34548();
		}
	}

	public static class_5944 terraPlate() {
		if (BotaniaConfig.client().useShaders()) {
			return terraPlate;
		} else {
			return class_757.method_34548();
		}
	}

	public static class_5944 enchanter() {
		if (BotaniaConfig.client().useShaders()) {
			return enchanter;
		} else {
			return class_757.method_34548();
		}
	}

	public static class_5944 pylon() {
		if (BotaniaConfig.client().useShaders()) {
			return pylon;
		} else {
			return class_757.method_34508();
		}
	}

	public static class_5944 halo() {
		if (BotaniaConfig.client().useShaders()) {
			return halo;
		} else {
			return class_757.method_34541();
		}
	}

	public static class_5944 filmGrainParticle() {
		if (BotaniaConfig.client().useShaders()) {
			return filmGrainParticle;
		} else {
			return class_757.method_34546();
		}
	}

	public static class_5944 dopplegangerBar() {
		if (BotaniaConfig.client().useShaders()) {
			return dopplegangerBar;
		} else {
			return class_757.method_34542();
		}
	}
}
