/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.api.state;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.state.enums.AlfheimPortalState;
import vazkii.botania.api.state.enums.CraftyCratePattern;

import java.util.Optional;
import net.minecraft.class_1767;
import net.minecraft.class_2350;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_3542;

/**
 * Holds all Botania block state properties. Use these to set botania blockstates
 */
public final class BotaniaStateProperties {

	public enum OptionalDyeColor implements class_3542 {
		WHITE,
		ORANGE,
		MAGENTA,
		LIGHT_BLUE,
		YELLOW,
		LIME,
		PINK,
		GRAY,
		LIGHT_GRAY,
		CYAN,
		PURPLE,
		BLUE,
		BROWN,
		GREEN,
		RED,
		BLACK,
		NONE;

		public Optional<class_1767> toDyeColor() {
			return switch (this) {
				case WHITE -> Optional.of(class_1767.field_7952);
				case ORANGE -> Optional.of(class_1767.field_7946);
				case MAGENTA -> Optional.of(class_1767.field_7958);
				case LIGHT_BLUE -> Optional.of(class_1767.field_7951);
				case YELLOW -> Optional.of(class_1767.field_7947);
				case LIME -> Optional.of(class_1767.field_7961);
				case PINK -> Optional.of(class_1767.field_7954);
				case GRAY -> Optional.of(class_1767.field_7944);
				case LIGHT_GRAY -> Optional.of(class_1767.field_7967);
				case CYAN -> Optional.of(class_1767.field_7955);
				case PURPLE -> Optional.of(class_1767.field_7945);
				case BLUE -> Optional.of(class_1767.field_7966);
				case BROWN -> Optional.of(class_1767.field_7957);
				case GREEN -> Optional.of(class_1767.field_7942);
				case RED -> Optional.of(class_1767.field_7964);
				case BLACK -> Optional.of(class_1767.field_7963);
				case NONE -> Optional.empty();
			};
		}

		public static OptionalDyeColor fromDyeColor(class_1767 color) {
			return switch (color) {
				case field_7952 -> WHITE;
				case field_7946 -> ORANGE;
				case field_7958 -> MAGENTA;
				case field_7951 -> LIGHT_BLUE;
				case field_7947 -> YELLOW;
				case field_7961 -> LIME;
				case field_7954 -> PINK;
				case field_7944 -> GRAY;
				case field_7967 -> LIGHT_GRAY;
				case field_7955 -> CYAN;
				case field_7945 -> PURPLE;
				case field_7966 -> BLUE;
				case field_7957 -> BROWN;
				case field_7942 -> GREEN;
				case field_7964 -> RED;
				case field_7963 -> BLACK;
			};
		}

		public static OptionalDyeColor fromOptionalDyeColor(Optional<class_1767> color) {
			return color.map(OptionalDyeColor::fromDyeColor).orElse(NONE);
		}

		@Override
		public @NotNull String method_15434() {
			return this.toDyeColor().map(class_1767::method_15434).orElse("none");
		}
	}

	// Currently only ManaPoolBlock
	public static final class_2754<OptionalDyeColor> OPTIONAL_DYE_COLOR = class_2754.method_11850("color", OptionalDyeColor.class);

	// AlfheimPortalBlock
	public static final class_2754<AlfheimPortalState> ALFPORTAL_STATE = class_2754.method_11850("state", AlfheimPortalState.class);

	// ManaEnchanterBlock
	public static final class_2754<class_2350.class_2351> ENCHANTER_DIRECTION = class_2754.method_11848("facing", class_2350.class_2351.class, a -> a != class_2350.class_2351.field_11052);

	// CraftyCrateBlock
	public static final class_2754<CraftyCratePattern> CRATE_PATTERN = class_2754.method_11850("pattern", CraftyCratePattern.class);

	// ManaPrismBlock
	public static final class_2746 HAS_LENS = class_2746.method_11825("has_lens");

	// ManaSpreaderBlock
	public static final class_2746 HAS_SCAFFOLDING = class_2746.method_11825("has_scaffolding");

	private BotaniaStateProperties() {}

}
