/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.mana;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1291;
import net.minecraft.class_1308;
import net.minecraft.class_1428;
import net.minecraft.class_1438;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1830;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_4970;
import net.minecraft.class_5147;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.mana.ManaTrigger;
import vazkii.botania.common.block.BotaniaWaterloggedBlock;
import vazkii.botania.common.block.flower.functional.BergamuteBlockEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.HornItem;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.mixin.LivingEntityAccessor;
import vazkii.botania.mixin.MushroomCowAccessor;

public class DrumBlock
extends BotaniaWaterloggedBlock {
    public static final int MAX_NUM_SHEARED = 4;
    public static final int GATHER_RANGE = 10;
    public static final int MINIMUM_REMAINING_EGG_TIME = 600;
    public static final int STARTLED_EGG_TIME = 200;
    private static final class_265 SHAPE = class_2248.method_9541((double)3.0, (double)1.0, (double)3.0, (double)13.0, (double)15.0, (double)13.0);
    private final Variant variant;

    public DrumBlock(Variant v, class_4970.class_2251 builder) {
        super(builder);
        this.variant = v;
    }

    @NotNull
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
        return SHAPE;
    }

    public static void gatherProduce(class_1937 world, class_2338 pos) {
        List mobs = world.method_8390(class_1308.class, new class_238(pos.method_10069(-10, -10, -10), pos.method_10069(11, 11, 11)), mob -> mob.method_5805() && !BergamuteBlockEntity.isBergamuteNearby(world, mob.method_23317(), mob.method_23318(), mob.method_23321()));
        ArrayList<class_5147> shearables = new ArrayList<class_5147>();
        for (class_1308 mob2 : mobs) {
            class_1438 mooshroom;
            class_1428 chicken;
            if (mob2 instanceof class_1428 && !(chicken = (class_1428)mob2).method_6109() && !chicken.method_6472()) {
                DrumBlock.speedUpEggLaying(chicken);
            }
            if (mob2.method_5864().method_20210(BotaniaTags.Entities.DRUM_MILKABLE) && !mob2.method_6109()) {
                DrumBlock.convertNearby(mob2, class_1802.field_8550, class_1802.field_8103);
            }
            if (mob2 instanceof class_1438 && !(mooshroom = (class_1438)mob2).method_6109()) {
                if (mooshroom.method_47847() == class_1438.class_4053.field_18110 && ((MushroomCowAccessor)mooshroom).getEffect() != null) {
                    DrumBlock.fillBowlSuspiciously(mooshroom);
                }
                DrumBlock.convertNearby(mob2, class_1802.field_8428, class_1802.field_8208);
            }
            if (!(mob2 instanceof class_5147)) continue;
            class_5147 shearable = (class_5147)mob2;
            if (mob2.method_5864().method_20210(BotaniaTags.Entities.DRUM_NO_SHEARING) || !shearable.method_27072()) continue;
            shearables.add(shearable);
        }
        Collections.shuffle(shearables);
        int sheared = 0;
        for (class_5147 shearable : shearables) {
            if (sheared > 4) break;
            shearable.method_6636(class_3419.field_15245);
            ++sheared;
        }
    }

    private static void speedUpEggLaying(class_1428 chicken) {
        if (chicken.field_6739 > 600) {
            chicken.field_6739 = Math.max(600, chicken.field_6739 / 2);
        } else if (chicken.field_6739 < 200 && chicken.field_6739 > 1) {
            chicken.field_6739 = 1;
            ((LivingEntityAccessor)chicken).botania_playHurtSound(chicken.method_48923().method_48831());
        }
    }

    private static void convertNearby(class_1308 mob, class_1792 from, class_1792 to) {
        class_1937 world = mob.method_37908();
        List fromEntities = world.method_8390(class_1542.class, mob.method_5829(), itemEntity -> itemEntity.method_5805() && itemEntity.method_6983().method_31574(from));
        for (class_1542 fromEntity : fromEntities) {
            class_1799 fromStack = fromEntity.method_6983();
            for (int i = fromStack.method_7947(); i > 0; --i) {
                DrumBlock.spawnItem(mob, new class_1799((class_1935)to));
            }
            fromEntity.method_31472();
        }
    }

    private static void spawnItem(class_1308 mob, class_1799 to) {
        class_1937 world = mob.method_37908();
        class_1542 ent = mob.method_5699(to, 1.0f);
        ent.method_18799(ent.method_18798().method_1031((double)(world.field_9229.method_43057() * 0.05f), (double)((world.field_9229.method_43057() - world.field_9229.method_43057()) * 0.1f), (double)((world.field_9229.method_43057() - world.field_9229.method_43057()) * 0.1f)));
    }

    private static void fillBowlSuspiciously(class_1438 mushroomCow) {
        block1: {
            MushroomCowAccessor mushroomCowAccessor = (MushroomCowAccessor)mushroomCow;
            class_1291 effect = mushroomCowAccessor.getEffect();
            int effectDuration = mushroomCowAccessor.getEffectDuration();
            class_1937 world = mushroomCow.method_37908();
            List bowlItemEntities = world.method_8390(class_1542.class, mushroomCow.method_5829(), itemEntity -> itemEntity.method_6983().method_31574(class_1802.field_8428) && !itemEntity.method_6983().method_7960());
            Iterator iterator = bowlItemEntities.iterator();
            if (!iterator.hasNext()) break block1;
            class_1542 bowlItemEntity = (class_1542)iterator.next();
            class_1799 bowlItem = bowlItemEntity.method_6983();
            class_1799 stewItem = new class_1799((class_1935)class_1802.field_8766);
            class_1830.method_8021((class_1799)stewItem, (class_1291)effect, (int)effectDuration);
            DrumBlock.spawnItem((class_1308)mushroomCow, stewItem);
            EntityHelper.shrinkItem(bowlItemEntity);
            if (bowlItem.method_7947() == 0) {
                bowlItemEntity.method_31472();
            }
            mushroomCowAccessor.setEffect(null);
            mushroomCowAccessor.setEffectDuration(0);
        }
    }

    public static enum Variant {
        WILD,
        GATHERING,
        CANOPY;

    }

    public static class ManaTriggerImpl
    implements ManaTrigger {
        private final class_1937 world;
        private final class_2338 pos;
        private final Variant variant;

        public ManaTriggerImpl(class_1937 world, class_2338 pos, class_2680 state) {
            this.world = world;
            this.pos = pos;
            this.variant = ((DrumBlock)state.method_26204()).variant;
        }

        @Override
        public void onBurstCollision(ManaBurst burst) {
            if (burst.isFake()) {
                return;
            }
            if (this.world.field_9236) {
                this.world.method_8406((class_2394)class_2398.field_11224, (double)this.pos.method_10263() + 0.5, (double)this.pos.method_10264() + 1.2, (double)this.pos.method_10260() + 0.5, 0.041666666666666664, 0.0, 0.0);
                return;
            }
            switch (this.variant) {
                case WILD: {
                    HornItem.breakGrass(this.world, new class_1799((class_1935)BotaniaItems.grassHorn), this.pos, null);
                    break;
                }
                case CANOPY: {
                    HornItem.breakGrass(this.world, new class_1799((class_1935)BotaniaItems.leavesHorn), this.pos, null);
                    break;
                }
                case GATHERING: {
                    DrumBlock.gatherProduce(this.world, this.pos);
                }
            }
            for (int i = 0; i < 10; ++i) {
                this.world.method_8396(null, this.pos, BotaniaSounds.drum, class_3419.field_15245, 1.0f, 1.0f);
            }
        }
    }
}

