package vazkii.botania.mixin;

import com.google.common.collect.ImmutableList;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

import vazkii.botania.common.item.ItemWithBannerPattern;

import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1726;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2582;
import net.minecraft.class_3917;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

@Mixin(class_1726.class)
public abstract class LoomMenuMixin extends class_1703 {
	protected LoomMenuMixin(@Nullable class_3917<?> menuType, int containerId) {
		super(menuType, containerId);
	}

	@Inject(at = @At("HEAD"), method = "getSelectablePatterns(Lnet/minecraft/world/item/ItemStack;)Ljava/util/List;", cancellable = true)
	private void handleBotaniaPatternItems(class_1799 stack, CallbackInfoReturnable<List<class_6880<class_2582>>> cir) {
		if (stack.method_7909() instanceof ItemWithBannerPattern p) {
			cir.setReturnValue(class_7923.field_41165.method_40266(p.getBannerPattern())
					.map(ImmutableList::copyOf).orElse(ImmutableList.of()));
		}
	}

	@Shadow
	@Final
	class_1735 patternSlot;

	@Inject(
		at = @At(value = "INVOKE", ordinal = 0, target = "Lnet/minecraft/world/item/ItemStack;getItem()Lnet/minecraft/world/item/Item;"),
		method = "quickMoveStack", cancellable = true, locals = LocalCapture.CAPTURE_FAILSOFT
	)
	private void handleBotaniaPatternQuickMoveStack(class_1657 player, int slotIndex, CallbackInfoReturnable<class_1799> cir, class_1799 dummyStack,
			class_1735 slot, class_1799 movedStack) {
		if (movedStack.method_7909() instanceof ItemWithBannerPattern
				&& method_7616(movedStack, this.patternSlot.field_7874, this.patternSlot.field_7874 + 1, false)) {
			cir.setReturnValue(class_1799.field_8037);
		}
	}
}
