/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.mixin;

import net.minecraft.class_1792;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import vazkii.botania.common.item.material.SelfReturningItem;

@Mixin(class_1792.class)
public class ItemMixin {
	@Inject(at = @At("HEAD"), method = "getCraftingRemainingItem", cancellable = true)
	private void returnSelf(CallbackInfoReturnable<class_1792> cir) {
		class_1792 self = (class_1792) (Object) this;
		if (self instanceof SelfReturningItem) {
			cir.setReturnValue(self);
		}
	}
}
