/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.fabric.client;

import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_5819;
import vazkii.botania.common.block.PlatformBlock;
import vazkii.botania.common.block.block_entity.PlatformBlockEntity;
import vazkii.botania.common.lib.BotaniaTags;

import java.util.function.Supplier;

public class FabricPlatformModel extends ForwardingBakedModel {
	public FabricPlatformModel(class_1087 original) {
		this.wrapped = original;
	}

	@Override
	public boolean isVanillaAdapter() {
		return false;
	}

	@Override
	public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
		if (!(state.method_26204() instanceof PlatformBlock)) {
			class_310.method_1551().method_1541().method_3351().method_3333().method_4744()
					.emitBlockQuads(blockView, state, pos, randomSupplier, context);
			return;
		}

		Object data = blockView.getBlockEntityRenderData(pos);
		if (data instanceof PlatformBlockEntity.PlatformData) {
			class_2338 heldPos = ((PlatformBlockEntity.PlatformData) data).pos();
			class_2680 heldState = ((PlatformBlockEntity.PlatformData) data).state();

			if (heldState == null || heldState.method_26164(BotaniaTags.Blocks.UNSUPPORTED_PLATFORM_DISGUISE)) {
				// No camo
				super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
			} else {
				class_1087 model = class_310.method_1551().method_1541()
						.method_3351().method_3335(heldState);
				// Steal camo's model
				model.emitBlockQuads(blockView, heldState, heldPos, randomSupplier, context);
			}
		}
	}

}
