/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.internal_caps;

import net.minecraft.class_2487;

// Component for misc internal Botania flags
public class ItemFlagsComponent extends SerializableComponent {
	public boolean elvenPortalSpawned = false;
	public boolean apothecarySpawned = false;
	public boolean manaInfusionSpawned = false;
	public boolean runicAltarSpawned = false;
	/**
	 * Similar to the age field on the actual entity, but always increases by 1 every tick,
	 * no magic values like vanilla -32768, etc.
	 * Initialized to zero by default, but may still be initialized to values less
	 * than zero in certain scenarios.
	 */
	public int timeCounter = 0;

	private static final String TAG_PORTAL_SPAWNED = "ElvenPortalSpawned";
	private static final String TAG_APOTHECARY_SPAWNED = "ApothecarySpawned";
	private static final String TAG_INFUSION_SPAWNED = "ManaInfusionSpawned";
	private static final String TAG_ALTAR_SPAWNED = "RunicAltarSpawned";

	private static final String TAG_TIME_COUNTER = "timeCounter";

	@Override
	public void readFromNbt(class_2487 tag) {
		elvenPortalSpawned = tag.method_10577(TAG_PORTAL_SPAWNED);
		apothecarySpawned = tag.method_10577(TAG_APOTHECARY_SPAWNED);
		manaInfusionSpawned = tag.method_10577(TAG_INFUSION_SPAWNED);
		runicAltarSpawned = tag.method_10577(TAG_ALTAR_SPAWNED);
		timeCounter = tag.method_10550(TAG_TIME_COUNTER);
		// legacy tags
		if (tag.method_10577("_elvenPortal")) {
			elvenPortalSpawned = true;
		}
		if (tag.method_10550("manaInfusionCooldown") > 0) {
			manaInfusionSpawned = true;
		}
		if (tag.method_10550("runicAltarCooldown") > 0) {
			runicAltarSpawned = true;
		}
	}

	@Override
	public void writeToNbt(class_2487 tag) {
		tag.method_10556(TAG_PORTAL_SPAWNED, elvenPortalSpawned);
		tag.method_10556(TAG_APOTHECARY_SPAWNED, apothecarySpawned);
		tag.method_10556(TAG_INFUSION_SPAWNED, runicAltarSpawned);
		tag.method_10556(TAG_ALTAR_SPAWNED, manaInfusionSpawned);
		tag.method_10569(TAG_TIME_COUNTER, timeCounter);
	}

	public void tick() {
		timeCounter++;
	}

	public boolean spawnedByInWorldRecipe() {
		return elvenPortalSpawned || apothecarySpawned || runicAltarSpawned || manaInfusionSpawned;
	}
}
