/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.helper;

import net.minecraft.class_1297;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import org.joml.Quaternionf;

public class VecHelper {
	public static final class_243 ONE = new class_243(1, 1, 1);

	private VecHelper() {}

	public static class_243 fromEntityCenter(class_1297 e) {
		return new class_243(e.method_23317(), e.method_23318() + e.method_17682() / 2, e.method_23321());
	}

	/**
	 * Rotates {@code v} by {@code theta} radians around {@code axis}
	 */
	public static class_243 rotate(class_243 v, double theta, class_243 axis) {
		if (class_3532.method_20390(theta, 0)) {
			return v;
		}

		// Rodrigues rotation formula
		class_243 k = axis.method_1029();

		float cosTheta = class_3532.method_15362((float) theta);
		class_243 firstTerm = v.method_1021(cosTheta);
		class_243 secondTerm = k.method_1036(v).method_1021(class_3532.method_15374((float) theta));
		class_243 thirdTerm = k.method_1021(k.method_1026(v) * (1 - cosTheta));
		return new class_243(firstTerm.field_1352 + secondTerm.field_1352 + thirdTerm.field_1352,
				firstTerm.field_1351 + secondTerm.field_1351 + thirdTerm.field_1351,
				firstTerm.field_1350 + secondTerm.field_1350 + thirdTerm.field_1350);
	}

	public static class_238 boxForRange(class_243 v, double range) {
		return boxForRange(v, range, range, range);
	}

	public static class_238 boxForRange(class_243 v, double rangeX, double rangeY, double rangeZ) {
		return new class_238(v.field_1352 - rangeX, v.field_1351 - rangeY, v.field_1350 - rangeZ, v.field_1352 + rangeX, v.field_1351 + rangeY, v.field_1350 + rangeZ);
	}

	public static float toRadians(float degrees) {
		return (float) (degrees / 180F * Math.PI);
	}

	public static Quaternionf rotateX(float degrees) {
		return new Quaternionf().rotateX(toRadians(degrees));
	}

	public static Quaternionf rotateY(float degrees) {
		return new Quaternionf().rotateY(toRadians(degrees));
	}

	public static Quaternionf rotateZ(float degrees) {
		return new Quaternionf().rotateZ(toRadians(degrees));
	}
}
