/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.block_entity;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_5217;
import net.minecraft.class_5268;

public class TeruTeruBozuBlockEntity extends BotaniaBlockEntity {
	private boolean wasRaining = false;

	public TeruTeruBozuBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaBlockEntities.TERU_TERU_BOZU, pos, state);
	}

	public static void serverTick(class_1937 level, class_2338 worldPosition, class_2680 state, TeruTeruBozuBlockEntity self) {
		boolean isRaining = level.method_8419();
		if (isRaining && level.field_9229.method_43048(9600) == 0) {
			level.method_8401().method_157(false);
			resetRainTime(level);
		}

		if (self.wasRaining != isRaining) {
			level.method_8455(worldPosition, state.method_26204());
		}
		self.wasRaining = isRaining;
	}

	public static void resetRainTime(class_1937 w) {
		int time = w.field_9229.method_43048(w.method_8401().method_156() ? 12000 : 168000) + 12000;
		class_5217 info = w.method_8401();
		if (info instanceof class_5268 serverInfo) {
			serverInfo.method_164(time);
		}
	}
}
