/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.entity;

import net.minecraft.class_1723;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_897;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.entity.MagicLandmineEntity;

public class MagicLandmineRenderer extends class_897<MagicLandmineEntity> {

	public MagicLandmineRenderer(class_5617.class_5618 ctx) {
		super(ctx);
	}

	@Override
	public void render(MagicLandmineEntity e, float entityYaw, float partialTicks, class_4587 ms, class_4597 buffers, int light) {
		super.method_3936(e, entityYaw, partialTicks, ms, buffers, light);

		ms.method_22903();
		class_238 aabb = e.method_5829().method_997(e.method_19538().method_1021(-1));

		float gs = (float) (Math.sin(ClientTickHandler.total() / 20) + 1) * 0.2F + 0.6F;
		int r = (int) (105 * gs);
		int g = (int) (25 * gs);
		int b = (int) (145 * gs);

		int alpha = 32;
		if (e.field_6012 < 8) {
			alpha *= Math.min((e.field_6012 + partialTicks) / 8F, 1F);
		} else if (e.field_6012 > 47) {
			alpha *= Math.min(1F - (e.field_6012 - 47 + partialTicks) / 8F, 1F);
		}

		ms.method_22904(aabb.field_1323, aabb.field_1322 + RenderHelper.getOffY(), aabb.field_1321);

		float f = 1F / 16F;
		float x = (float) (aabb.method_17939() - f);
		float z = (float) (aabb.method_17941() - f);

		class_4588 buffer = buffers.getBuffer(RenderHelper.RECTANGLE);
		Matrix4f mat = ms.method_23760().method_23761();
		RenderHelper.flatRectangle(buffer, mat, f, x, 0, f, z, r, g, b, alpha);
		RenderHelper.incrementOffY();
		ms.method_22909();
	}

	@NotNull
	@Override
	public class_2960 getTextureLocation(@NotNull MagicLandmineEntity entity) {
		return class_1723.field_21668;
	}
}
