/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.block_entity;

import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;

import vazkii.botania.api.state.BotaniaStateProperties;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.handler.MiscellaneousModels;
import vazkii.botania.common.block.block_entity.mana.ManaSpreaderBlockEntity;
import vazkii.botania.common.block.mana.ManaSpreaderBlock;
import vazkii.botania.common.helper.VecHelper;

import java.util.Random;
import net.minecraft.class_1087;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4696;
import net.minecraft.class_5614;
import net.minecraft.class_811;
import net.minecraft.class_827;

public class ManaSpreaderBlockEntityRenderer implements class_827<ManaSpreaderBlockEntity> {

	public ManaSpreaderBlockEntityRenderer(class_5614.class_5615 ctx) {}

	@Override
	public void render(@NotNull ManaSpreaderBlockEntity spreader, float partialTicks, class_4587 ms, class_4597 buffers, int light, int overlay) {
		ms.method_22903();

		ms.method_22904(0.5F, 0.5, 0.5F);

		Quaternionf transform = VecHelper.rotateY(spreader.rotationX + 90F);
		transform.mul(VecHelper.rotateX(spreader.rotationY));
		ms.method_22907(transform);

		ms.method_46416(-0.5F, -0.5F, -0.5F);

		double time = ClientTickHandler.ticksInGame + partialTicks;

		float r = 1, g = 1, b = 1;
		if (spreader.getVariant() == ManaSpreaderBlock.Variant.GAIA) {
			int color = class_3532.method_15369((float) ((time * 2 + new Random(spreader.method_11016().hashCode()).nextInt(10000)) % 360) / 360F, 0.4F, 0.9F);
			r = (color >> 16 & 0xFF) / 255F;
			g = (color >> 8 & 0xFF) / 255F;
			b = (color & 0xFF) / 255F;
		}

		class_4588 buffer = buffers.getBuffer(class_4696.method_23683(spreader.method_11010(), false));
		class_1087 spreaderModel = class_310.method_1551().method_1541().method_3349(spreader.method_11010());
		class_310.method_1551().method_1541().method_3350()
				.method_3367(ms.method_23760(), buffer, spreader.method_11010(),
						spreaderModel, r, g, b, light, overlay);

		ms.method_22903();
		ms.method_22904(0.5, 0.5, 0.5);
		ms.method_22907(VecHelper.rotateY((float) time % 360));
		ms.method_22904(-0.5, -0.5, -0.5);
		ms.method_46416(0F, (float) Math.sin(time / 20.0) * 0.05F, 0F);
		class_1087 core = getCoreModel(spreader);
		class_310.method_1551().method_1541().method_3350()
				.method_3367(ms.method_23760(), buffer, spreader.method_11010(),
						core, 1, 1, 1, light, overlay);
		ms.method_22909();

		class_1799 stack = spreader.getItemHandler().method_5438(0);
		if (!stack.method_7960()) {
			ms.method_22903();
			ms.method_46416(0.5F, 0.5F, 0.094F);
			ms.method_22907(VecHelper.rotateZ(180));
			ms.method_22907(VecHelper.rotateX(180));
			// Prevents z-fighting. Otherwise not noticeable.
			ms.method_22905(0.997F, 0.997F, 1F);
			class_310.method_1551().method_1480().method_23178(stack, class_811.field_4315,
					light, overlay, ms, buffers, spreader.method_10997(), 0);
			ms.method_22909();
		}

		if (spreader.paddingColor != null) {
			ms.method_22903();
			// The padding model is facing up so that the textures are rotated the correct way
			// It's simpler to do this than mess with rotation and UV in the json model
			ms.method_46416(0.5F, 0.5F, 0.5F);
			ms.method_22907(VecHelper.rotateX(-90));
			ms.method_22907(VecHelper.rotateY(180));
			ms.method_46416(-0.5F, -0.5F, -0.5F);
			class_1087 paddingModel = getPaddingModel(spreader.paddingColor);
			class_310.method_1551().method_1541().method_3350()
					.method_3367(ms.method_23760(), buffer, spreader.method_11010(),
							paddingModel, r, g, b, light, overlay);
			ms.method_22909();
		}

		ms.method_22909();

		if (spreader.method_11010().method_11654(BotaniaStateProperties.HAS_SCAFFOLDING)) {
			class_1087 scaffolding = getScaffoldingModel(spreader);
			class_310.method_1551().method_1541().method_3350()
					.method_3367(ms.method_23760(), buffer, spreader.method_11010(),
							scaffolding, r, g, b, light, overlay);
		}

	}

	private class_1087 getCoreModel(ManaSpreaderBlockEntity tile) {
		return switch (tile.getVariant()) {
			case GAIA -> MiscellaneousModels.INSTANCE.gaiaSpreaderCore;
			case REDSTONE -> MiscellaneousModels.INSTANCE.redstoneSpreaderCore;
			case ELVEN -> MiscellaneousModels.INSTANCE.elvenSpreaderCore;
			case MANA -> MiscellaneousModels.INSTANCE.manaSpreaderCore;
		};
	}

	private class_1087 getPaddingModel(class_1767 color) {
		return MiscellaneousModels.INSTANCE.spreaderPaddings.get(color);
	}

	private class_1087 getScaffoldingModel(ManaSpreaderBlockEntity tile) {
		return switch (tile.getVariant()) {
			case MANA, REDSTONE -> MiscellaneousModels.INSTANCE.manaSpreaderScaffolding;
			case ELVEN -> MiscellaneousModels.INSTANCE.elvenSpreaderScaffolding;
			case GAIA -> MiscellaneousModels.INSTANCE.gaiaSpreaderScaffolding;
		};
	}
}
