/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.model.armor;

import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_572;
import net.minecraft.class_630;

public class ArmorModel extends class_572<class_1309> {
	protected final class_1304 slot;

	public ArmorModel(class_630 root, class_1304 slot) {
		super(root);
		this.slot = slot;
	}

	// [VanillaCopy] ArmorStandArmorModel.setupAnim because armor stands are dumb
	// This fixes the armor "breathing" and helmets always facing south on armor stands
	@Override
	public void method_17087(class_1309 entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
		if (!(entity instanceof class_1531 entityIn)) {
			super.method_17087(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
			return;
		}

		this.field_3398.field_3654 = ((float) Math.PI / 180F) * entityIn.method_6921().method_10256();
		this.field_3398.field_3675 = ((float) Math.PI / 180F) * entityIn.method_6921().method_10257();
		this.field_3398.field_3674 = ((float) Math.PI / 180F) * entityIn.method_6921().method_10258();
		this.field_3398.method_2851(0.0F, 1.0F, 0.0F);
		this.field_3391.field_3654 = ((float) Math.PI / 180F) * entityIn.method_6923().method_10256();
		this.field_3391.field_3675 = ((float) Math.PI / 180F) * entityIn.method_6923().method_10257();
		this.field_3391.field_3674 = ((float) Math.PI / 180F) * entityIn.method_6923().method_10258();
		this.field_27433.field_3654 = ((float) Math.PI / 180F) * entityIn.method_6930().method_10256();
		this.field_27433.field_3675 = ((float) Math.PI / 180F) * entityIn.method_6930().method_10257();
		this.field_27433.field_3674 = ((float) Math.PI / 180F) * entityIn.method_6930().method_10258();
		this.field_3401.field_3654 = ((float) Math.PI / 180F) * entityIn.method_6903().method_10256();
		this.field_3401.field_3675 = ((float) Math.PI / 180F) * entityIn.method_6903().method_10257();
		this.field_3401.field_3674 = ((float) Math.PI / 180F) * entityIn.method_6903().method_10258();
		this.field_3397.field_3654 = ((float) Math.PI / 180F) * entityIn.method_6917().method_10256();
		this.field_3397.field_3675 = ((float) Math.PI / 180F) * entityIn.method_6917().method_10257();
		this.field_3397.field_3674 = ((float) Math.PI / 180F) * entityIn.method_6917().method_10258();
		this.field_3397.method_2851(1.9F, 11.0F, 0.0F);
		this.field_3392.field_3654 = ((float) Math.PI / 180F) * entityIn.method_6900().method_10256();
		this.field_3392.field_3675 = ((float) Math.PI / 180F) * entityIn.method_6900().method_10257();
		this.field_3392.field_3674 = ((float) Math.PI / 180F) * entityIn.method_6900().method_10258();
		this.field_3392.method_2851(-1.9F, 11.0F, 0.0F);
		this.field_3394.method_17138(this.field_3398);
	}

	@Override
	public void method_2828(class_4587 ms, class_4588 buffer, int light, int overlay, float r, float g, float b, float a) {
		setPartVisibility(slot);
		super.method_2828(ms, buffer, light, overlay, r, g, b, a);
	}

	// [VanillaCopy] HumanoidArmorLayer
	private void setPartVisibility(class_1304 slot) {
		method_2805(false);
		switch (slot) {
			case field_6169 -> {
				field_3398.field_3665 = true;
				field_3394.field_3665 = true;
			}
			case field_6174 -> {
				field_3391.field_3665 = true;
				field_3401.field_3665 = true;
				field_27433.field_3665 = true;
			}
			case field_6172 -> {
				field_3391.field_3665 = true;
				field_3392.field_3665 = true;
				field_3397.field_3665 = true;
			}
			case field_6166 -> {
				field_3392.field_3665 = true;
				field_3397.field_3665 = true;
			}
		}
	}
}
