/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.api.recipe;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import java.util.List;

/**
 * An event fired when an Elven Portal updates. The portal's
 * relevant bounding box and other stuff is passed in for convenience.
 */
public interface ElvenPortalUpdateCallback {
	Event<ElvenPortalUpdateCallback> EVENT = EventFactory.createArrayBacked(ElvenPortalUpdateCallback.class,
			listeners -> (be, bounds, open, stacks) -> {
				for (ElvenPortalUpdateCallback listener : listeners) {
					listener.onElvenPortalTick(be, bounds, open, stacks);
				}
			});

	/**
	 * @param portal May be casted to AlfheimPortalBlockEntity if you have botania code access aside from the API.
	 */
	void onElvenPortalTick(class_2586 portal, class_238 bounds, boolean open, List<class_1799> stacksInside);

}
