/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.api.mana;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1657;
import net.minecraft.class_1799;

public interface ManaProficiencyCallback {
	Event<ManaProficiencyCallback> EVENT = EventFactory.createArrayBacked(ManaProficiencyCallback.class,
			listeners -> (pl, st, cur) -> {
				for (ManaProficiencyCallback listener : listeners) {
					cur = listener.getProficient(pl, st, cur);
				}

				return cur;
			});

	boolean getProficient(class_1657 player, class_1799 tool, boolean curProficient);
}
