/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.test.block;

import java.util.Optional;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1430;
import net.minecraft.class_1438;
import net.minecraft.class_1472;
import net.minecraft.class_1473;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_4516;
import net.minecraft.class_6302;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.mana.ManaSpreaderBlockEntity;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.mixin.MushroomCowAccessor;
import vazkii.botania.test.TestingUtil;

public class DrumBlockTest {
    private static final String TEMPLATE = "botania:block/drum_gathering";
    private static final class_2338 POSITION_BUTTON = new class_2338(10, 10, 9);
    private static final class_2338 POSITION_SPREADER = new class_2338(10, 10, 10);
    private static final class_2338 POSITION_DRUM = new class_2338(10, 11, 10);
    private static final class_2338 POSITION_BERGAMUTE = new class_2338(11, 2, 11);
    private static final class_2338 POSITION_MOB = new class_2338(10, 2, 10);
    private static final class_243 VECTOR_MOB = POSITION_MOB.method_46558();

    private static <T extends class_1308> T setup(class_4516 helper, class_1299<T> entityType, @Nullable class_1792 item) {
        class_1657 player = helper.method_36021();
        ManaSpreaderBlockEntity spreader = TestingUtil.assertBlockEntity(helper, POSITION_SPREADER, BotaniaBlockEntities.SPREADER);
        TestingUtil.assertThat(spreader.bindTo(player, new class_1799((class_1935)BotaniaItems.twigWand), helper.method_36052(POSITION_DRUM), class_2350.field_11036), () -> "Failed to bind spreader");
        if (item != null) {
            helper.method_35968(item, (float)VECTOR_MOB.method_10216(), (float)VECTOR_MOB.method_10214(), (float)VECTOR_MOB.method_10215());
        }
        return (T)((class_1308)helper.method_35963(entityType, VECTOR_MOB));
    }

    private static <T extends class_1308> void testMilkingAdultAnimal(class_4516 helper, class_1299<T> entityType, class_1792 inputItem, class_1792 outputItem) {
        DrumBlockTest.setup(helper, entityType, inputItem);
        helper.method_36041().method_36077(1, () -> helper.method_36026(POSITION_BUTTON)).method_36079(() -> helper.method_35969(outputItem, POSITION_MOB, 1.0)).method_36075();
    }

    @class_6302(method_35936="botania:block/drum_gathering", method_35932=20)
    public void testMilkingGoat(class_4516 helper) {
        DrumBlockTest.testMilkingAdultAnimal(helper, class_1299.field_30052, class_1802.field_8550, class_1802.field_8103);
    }

    @class_6302(method_35936="botania:block/drum_gathering", method_35932=20)
    public void testMilkingCow(class_4516 helper) {
        DrumBlockTest.testMilkingAdultAnimal(helper, class_1299.field_6085, class_1802.field_8550, class_1802.field_8103);
    }

    @class_6302(method_35936="botania:block/drum_gathering", method_35932=20)
    public void testMilkingMooshroom(class_4516 helper) {
        DrumBlockTest.testMilkingAdultAnimal(helper, class_1299.field_6143, class_1802.field_8550, class_1802.field_8103);
    }

    @class_6302(method_35936="botania:block/drum_gathering", method_35932=20)
    public void testMilkingMooshroomSoup(class_4516 helper) {
        DrumBlockTest.testMilkingAdultAnimal(helper, class_1299.field_6143, class_1802.field_8428, class_1802.field_8208);
    }

    @class_6302(method_35936="botania:block/drum_gathering", method_35932=20)
    public void testMilkingBrownMooshroomSuspiciousStew(class_4516 helper) {
        class_1438 cow = (class_1438)DrumBlockTest.setup(helper, class_1299.field_6143, class_1802.field_8428);
        cow.method_47846(class_1438.class_4053.field_18110);
        MushroomCowAccessor cowAccessor = (MushroomCowAccessor)cow;
        cowAccessor.setEffect(class_1294.field_5919);
        cowAccessor.setEffectDuration(15);
        helper.method_36041().method_36077(1, () -> helper.method_36026(POSITION_BUTTON)).method_36079(() -> helper.method_35969(class_1802.field_8766, POSITION_MOB, 1.0)).method_36085(() -> {
            Optional item = helper.method_44335(class_1299.field_6052, POSITION_MOB, 1.0).stream().findFirst();
            helper.method_46226(item.isPresent() && ((class_1542)item.get()).method_6983().method_31574(class_1802.field_8766), "Item not found or not suspicious stew");
            class_2487 nbt = ((class_1542)item.get()).method_6983().method_7969();
            helper.method_46226(nbt.method_10573("Effects", 9), "Missing effects list tag");
            class_2499 effects = nbt.method_10554("Effects", 10);
            helper.method_46226(effects.size() == 1, "Exactly one effect expected");
            class_2487 effectTag = effects.method_10602(0);
            helper.method_46226(effectTag.method_10573("EffectId", 3) && effectTag.method_10573("EffectDuration", 3), "Missing ID and/or duration tag for effect");
            class_1291 effect = class_1291.method_5569((int)effectTag.method_10550("EffectId"));
            int effectDuration = effectTag.method_10550("EffectDuration");
            helper.method_46226(effect == class_1294.field_5919 && effectDuration == 15, "Unexpected effect type or duration");
        }).method_36075();
    }

    private static <T extends class_1308> void testMilkingBabyAnimal(class_4516 helper, class_1299<T> entityType, class_1792 item) {
        T baby = DrumBlockTest.setup(helper, entityType, item);
        baby.method_7217(true);
        helper.method_36041().method_36077(1, () -> helper.method_36026(POSITION_BUTTON)).method_36077(20, () -> helper.method_35969(item, POSITION_MOB, 1.0)).method_36075();
    }

    @class_6302(method_35936="botania:block/drum_gathering", method_35932=25)
    public void testMilkingBabyGoat(class_4516 helper) {
        DrumBlockTest.testMilkingBabyAnimal(helper, class_1299.field_30052, class_1802.field_8550);
    }

    @class_6302(method_35936="botania:block/drum_gathering", method_35932=25)
    public void testMilkingBabyMooshroom(class_4516 helper) {
        DrumBlockTest.testMilkingBabyAnimal(helper, class_1299.field_6143, class_1802.field_8428);
    }

    @class_6302(method_35936="botania:block/drum_gathering", method_35932=25)
    public void testMilkingDeadAnimal(class_4516 helper) {
        class_1430 cow = (class_1430)DrumBlockTest.setup(helper, class_1299.field_6085, class_1802.field_8550);
        helper.method_36041().method_36085(() -> ((class_1430)cow).method_5768()).method_36077(1, () -> helper.method_36026(POSITION_BUTTON)).method_36077(20, () -> helper.method_35969(class_1802.field_8550, POSITION_MOB, 1.0)).method_36075();
    }

    @class_6302(method_35936="botania:block/drum_gathering", method_35932=25)
    public void testMilkingNearBergamute(class_4516 helper) {
        DrumBlockTest.setup(helper, class_1299.field_6085, class_1802.field_8550);
        helper.method_35984(POSITION_BERGAMUTE, BotaniaFlowerBlocks.bergamuteFloating);
        helper.method_36041().method_36077(1, () -> helper.method_36026(POSITION_BUTTON)).method_36077(20, () -> helper.method_35969(class_1802.field_8550, POSITION_MOB, 1.0)).method_36075();
    }

    @class_6302(method_35936="botania:block/drum_gathering", method_35932=20)
    public void testShearingSheep(class_4516 helper) {
        class_1472 sheep = (class_1472)DrumBlockTest.setup(helper, class_1299.field_6115, null);
        sheep.method_6631(class_1767.field_7961);
        helper.method_36041().method_36077(1, () -> helper.method_36026(POSITION_BUTTON)).method_36079(() -> helper.method_35969(class_1802.field_19049, POSITION_MOB, 1.0)).method_36085(() -> helper.method_46226(sheep.method_5805() && sheep.method_6629(), "Sheep should be sheared")).method_36075();
    }

    @class_6302(method_35936="botania:block/drum_gathering", method_35932=25)
    public void testShearingBabySheep(class_4516 helper) {
        class_1472 sheep = (class_1472)DrumBlockTest.setup(helper, class_1299.field_6115, null);
        sheep.method_7217(true);
        helper.method_36041().method_36077(1, () -> helper.method_36026(POSITION_BUTTON)).method_36077(20, () -> helper.method_46226(sheep.method_5805() && !sheep.method_6629(), "Baby sheep should not be sheared")).method_36075();
    }

    @class_6302(method_35936="botania:block/drum_gathering", method_35932=20)
    public void testShearingSnowGolem(class_4516 helper) {
        class_1473 golem = (class_1473)DrumBlockTest.setup(helper, class_1299.field_6047, null);
        helper.method_36041().method_36077(1, () -> helper.method_36026(POSITION_BUTTON)).method_36079(() -> helper.method_35969(class_1802.field_17519, POSITION_MOB, 1.0)).method_36085(() -> helper.method_46226(golem.method_5805() && !golem.method_6643(), "Snow golem should not wear a pumpkin")).method_36075();
    }

    @class_6302(method_35936="botania:block/drum_gathering", method_35932=20)
    public void testShearingPumpkinlessSnowGolem(class_4516 helper) {
        class_1473 golem = (class_1473)DrumBlockTest.setup(helper, class_1299.field_6047, null);
        golem.method_6642(false);
        helper.method_36041().method_36085(() -> helper.method_36026(POSITION_BUTTON)).method_36077(20, () -> helper.method_46226(golem.method_5805() && !golem.method_6643(), "Snow golem should not wear a pumpkin")).method_36085(() -> helper.method_42762(class_1802.field_17519, POSITION_MOB, 1.0)).method_36075();
    }

    @class_6302(method_35936="botania:block/drum_gathering", method_35932=25)
    public void testShearingMooshroom(class_4516 helper) {
        DrumBlockTest.setup(helper, class_1299.field_6143, null);
        helper.method_36041().method_36077(1, () -> helper.method_36026(POSITION_BUTTON)).method_36077(20, () -> helper.method_36004(class_1299.field_6085)).method_36075();
    }
}

