/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.block_entity;

import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_1058;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1723;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_827;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.api.state.enums.LuminizerVariant;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.render.block_entity.SpecialFlowerBlockEntityRenderer;
import vazkii.botania.common.block.LuminizerBlock;
import vazkii.botania.common.block.block_entity.LuminizerBlockEntity;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.equipment.bauble.ManaseerMonocleItem;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class LuminizerBlockEntityRenderer
implements class_827<LuminizerBlockEntity> {
    private final class_1058 luminizerWorldSprite;
    private final class_1058 detectorLuminizerWorldSprite;
    private final class_1058 forkLuminizerWorldSprite;
    private final class_1058 toggleLuminizerWorldSprite;

    public LuminizerBlockEntityRenderer(class_5614.class_5615 ctx) {
        Function atlas = class_310.method_1551().method_1549(class_1723.field_21668);
        this.luminizerWorldSprite = Objects.requireNonNull((class_1058)atlas.apply(ResourceLocationHelper.prefix("block/light_relay")));
        this.detectorLuminizerWorldSprite = Objects.requireNonNull((class_1058)atlas.apply(ResourceLocationHelper.prefix("block/detector_light_relay")));
        this.forkLuminizerWorldSprite = Objects.requireNonNull((class_1058)atlas.apply(ResourceLocationHelper.prefix("block/fork_light_relay")));
        this.toggleLuminizerWorldSprite = Objects.requireNonNull((class_1058)atlas.apply(ResourceLocationHelper.prefix("block/toggle_light_relay")));
    }

    public void render(@NotNull LuminizerBlockEntity tile, float pticks, class_4587 ms, class_4597 buffers, int light, int overlay) {
        class_1309 view;
        class_2680 state = tile.method_11010();
        class_310 mc = class_310.method_1551();
        class_1297 class_12972 = mc.method_1560();
        if (class_12972 instanceof class_1309 && ManaseerMonocleItem.hasMonocle(view = (class_1309)class_12972) && SpecialFlowerBlockEntityRenderer.hasBindingAttempt(view, tile.method_11016())) {
            SpecialFlowerBlockEntityRenderer.renderRadius(tile, ms, buffers, new RadiusDescriptor.Circle(tile.method_11016(), 20.0));
        }
        class_1058 sprite = switch (((LuminizerBlock)state.method_26204()).variant) {
            default -> throw new IncompatibleClassChangeError();
            case LuminizerVariant.DEFAULT -> this.luminizerWorldSprite;
            case LuminizerVariant.DETECTOR -> this.detectorLuminizerWorldSprite;
            case LuminizerVariant.FORK -> this.forkLuminizerWorldSprite;
            case LuminizerVariant.TOGGLE -> this.toggleLuminizerWorldSprite;
        };
        ms.method_22903();
        ms.method_22904(0.5, 0.3, 0.5);
        double time = (float)ClientTickHandler.ticksInGame + pticks;
        float scale = 0.75f;
        ms.method_22905(scale, scale, scale);
        ms.method_22907(mc.method_1561().method_24197());
        ms.method_22907(VecHelper.rotateY(180.0f));
        float off = 0.25f;
        ms.method_46416(0.0f, off, 0.0f);
        ms.method_22907(VecHelper.rotateZ((float)time));
        ms.method_46416(0.0f, -off, 0.0f);
        class_4588 buffer = buffers.getBuffer(RenderHelper.LIGHT_RELAY);
        this.renderIcon(ms, buffer, sprite);
        ms.method_22909();
    }

    private void renderIcon(class_4587 ms, class_4588 buffer, class_1058 icon) {
        float size = icon.method_4577() - icon.method_4594();
        float pad = size / 8.0f;
        float f = icon.method_4594() + pad;
        float f1 = icon.method_4577() - pad;
        float f2 = icon.method_4593() + pad;
        float f3 = icon.method_4575() - pad;
        float f4 = 1.0f;
        float f5 = 0.5f;
        float f6 = 0.25f;
        Matrix4f mat = ms.method_23760().method_23761();
        buffer.method_22918(mat, 0.0f - f5, 0.0f - f6, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(f, f3).method_1344();
        buffer.method_22918(mat, f4 - f5, 0.0f - f6, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(f1, f3).method_1344();
        buffer.method_22918(mat, f4 - f5, f4 - f6, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(f1, f2).method_1344();
        buffer.method_22918(mat, 0.0f - f5, f4 - f6, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(f, f2).method_1344();
    }
}

