/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.data.recipes;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.crafting.StateIngredientHelper;

import java.util.function.Consumer;
import net.minecraft.class_1865;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_7784;
import net.minecraft.class_7923;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class PureDaisyProvider extends BotaniaRecipeProvider {
	public PureDaisyProvider(class_7784 packOutput) {
		super(packOutput);
	}

	@Override
	public void buildRecipes(Consumer<net.minecraft.class_2444> consumer) {

		consumer.accept(new FinishedRecipe(id("livingrock"), StateIngredientHelper.of(class_2246.field_10340), BotaniaBlocks.livingrock.method_9564()));
		consumer.accept(new StateCopyingRecipe(id("livingwood"),
				StateIngredientHelper.of(class_3481.field_15475),
				BotaniaBlocks.livingwoodLog));

		consumer.accept(new FinishedRecipe(id("cobblestone"), StateIngredientHelper.of(class_2246.field_10515), class_2246.field_10445.method_9564()));
		consumer.accept(new FinishedRecipe(id("end_stone_to_cobbled_deepslate"), StateIngredientHelper.of(class_2246.field_10471), class_2246.field_29031.method_9564(), FinishedRecipe.DEFAULT_TIME, prefix("ender_air_release")));
		consumer.accept(new FinishedRecipe(id("sand"), StateIngredientHelper.of(class_2246.field_10114), class_2246.field_10102.method_9564()));
		consumer.accept(new FinishedRecipe(id("packed_ice"), StateIngredientHelper.of(class_2246.field_10295), class_2246.field_10225.method_9564()));
		consumer.accept(new FinishedRecipe(id("blue_ice"), StateIngredientHelper.of(class_2246.field_10225), class_2246.field_10384.method_9564()));
		consumer.accept(new FinishedRecipe(id("obsidian"), StateIngredientHelper.of(BotaniaBlocks.blazeBlock), class_2246.field_10540.method_9564()));
		consumer.accept(new FinishedRecipe(id("snow_block"), StateIngredientHelper.of(class_2246.field_10382), class_2246.field_10491.method_9564()));
	}

	@Override
	public String method_10321() {
		return "Botania Pure Daisy recipes";
	}

	private static class_2960 id(String path) {
		return prefix("pure_daisy/" + path);
	}

	protected static class FinishedRecipe implements net.minecraft.class_2444 {
		public static final int DEFAULT_TIME = 150;

		protected final class_2960 id;
		protected final StateIngredient input;
		protected final class_2680 outputState;
		protected final int time;
		@Nullable
		private final class_2960 function;

		public FinishedRecipe(class_2960 id, StateIngredient input, class_2680 state) {
			this(id, input, state, DEFAULT_TIME);
		}

		public FinishedRecipe(class_2960 id, StateIngredient input, class_2680 state, int time) {
			this(id, input, state, time, null);
		}

		public FinishedRecipe(class_2960 id, StateIngredient input, class_2680 state, int time, @Nullable class_2960 function) {
			Preconditions.checkArgument(time >= 0, "Time must be nonnegative");
			this.id = id;
			this.input = input;
			this.outputState = state;
			this.time = time;
			this.function = function;
		}

		@Override
		public void method_10416(JsonObject json) {
			json.add("input", input.serialize());
			json.add("output", StateIngredientHelper.serializeBlockState(outputState));
			if (time != DEFAULT_TIME) {
				json.addProperty("time", time);
			}
			if (function != null) {
				json.addProperty("success_function", function.toString());
			}
		}

		@Override
		public class_2960 method_10417() {
			return id;
		}

		@Override
		public class_1865<?> method_17800() {
			return BotaniaRecipeTypes.PURE_DAISY_SERIALIZER;
		}

		@Nullable
		@Override
		public JsonObject method_10415() {
			return null;
		}

		@Nullable
		@Override
		public class_2960 method_10418() {
			return null;
		}
	}

	protected static class StateCopyingRecipe extends FinishedRecipe {
		public StateCopyingRecipe(class_2960 id, StateIngredient input, class_2248 block) {
			super(id, input, block.method_9564());
		}

		@Override
		public void method_10416(JsonObject json) {
			json.add("input", input.serialize());
			json.addProperty("output", class_7923.field_41175.method_10221(outputState.method_26204()).toString());
			if (time != DEFAULT_TIME) {
				json.addProperty("time", time);
			}
		}

		@Override
		public class_1865<?> method_17800() {
			return BotaniaRecipeTypes.COPYING_PURE_DAISY_SERIALIZER;
		}
	}
}
