/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.bauble;

import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.helper.EntityHelper;

public class RingOfTheMantleItem extends BaubleItem {

	public static final int MANA_COST = 5;
	public static final int HASTE_AMPLIFIER = 1; // Haste 2

	public RingOfTheMantleItem(class_1793 props) {
		super(props);
	}

	@Override
	public void onWornTick(class_1799 stack, class_1309 entity) {
		if (!(entity instanceof class_1657 player) || player.method_37908().field_9236) {
			return;
		}
		boolean hasMana = ManaItemHandler.instance().requestManaExact(stack, player, MANA_COST, false);
		if (!hasMana) {
			onUnequipped(stack, player);
		} else {
			onEquipped(stack, player);
		}

		if (player.field_6251 == 0.25F) {
			ManaItemHandler.instance().requestManaExact(stack, player, MANA_COST, true);
		}
	}

	@Override
	public void onEquipped(class_1799 stack, class_1309 living) {
		boolean hasMana = living instanceof class_1657 player
				&& ManaItemHandler.instance().requestManaExact(stack, player, MANA_COST, false);
		if (hasMana) {
			EntityHelper.addStaticEffect(living, class_1294.field_5917, HASTE_AMPLIFIER);
		}
	}

	@Override
	public void onUnequipped(class_1799 stack, class_1309 living) {
		EntityHelper.removeStaticEffect(living, class_1294.field_5917, HASTE_AMPLIFIER);
	}

}
