/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.common.entity.VineBallEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.PlayerHelper;

import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_3419;
import net.minecraft.class_5328;

public class LivingwoodSlingshotItem extends class_1792 {

	private static final Predicate<class_1799> AMMO_FUNC = s -> s != null && s.method_31574(BotaniaItems.vineBall);

	public LivingwoodSlingshotItem(class_1793 builder) {
		super(builder);
	}

	@Override
	public void method_7840(class_1799 stack, class_1937 world, class_1309 living, int duration) {
		int j = method_7881(stack) - duration;

		if (!world.field_9236 && (!(living instanceof class_1657 player) || player.method_31549().field_7477 || PlayerHelper.hasAmmo(player, AMMO_FUNC))) {
			float f = j / 20.0F;
			f = (f * f + f * 2.0F) / 3.0F;

			if (f < 1F) {
				return;
			}

			if (living instanceof class_1657 player && !player.method_31549().field_7477) {
				PlayerHelper.consumeAmmo(player, AMMO_FUNC);
			}

			VineBallEntity ball = new VineBallEntity(living, false);
			ball.method_24919(living, living.method_36455(), living.method_36454(), 0F, 1.5F, 1F);
			ball.method_18799(ball.method_18798().method_1021(1.6));
			world.method_8649(ball);
			world.method_43128(null, living.method_23317(), living.method_23318(), living.method_23321(), BotaniaSounds.vineBallThrow, class_3419.field_15254, 1F, 0.4F / (living.method_6051().method_43057() * 0.4F + 0.8F));
		}
	}

	@Override
	public int method_7881(class_1799 stack) {
		return 72000;
	}

	@NotNull
	@Override
	public class_1839 method_7853(class_1799 stack) {
		return class_1839.field_8953;
	}

	@NotNull
	@Override
	public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @NotNull class_1268 hand) {
		class_1799 stack = player.method_5998(hand);
		if (player.method_31549().field_7477 || PlayerHelper.hasAmmo(player, AMMO_FUNC)) {
			return class_5328.method_29282(world, player, hand);
		}

		return class_1271.method_22430(stack);
	}

}
