/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_5558;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.state.BotaniaStateProperties;
import vazkii.botania.api.state.enums.AlfheimPortalState;
import vazkii.botania.common.block.block_entity.AlfheimPortalBlockEntity;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;

public class AlfheimPortalBlock extends BotaniaBlock implements class_2343 {

	public AlfheimPortalBlock(class_2251 builder) {
		super(builder);
		method_9590(method_9564().method_11657(BotaniaStateProperties.ALFPORTAL_STATE, AlfheimPortalState.OFF));
	}

	@Override
	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		builder.method_11667(BotaniaStateProperties.ALFPORTAL_STATE);
	}

	@NotNull
	@Override
	public class_2586 method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
		return new AlfheimPortalBlockEntity(pos, state);
	}

	@Nullable
	@Override
	public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
		return createTickerHelper(type, BotaniaBlockEntities.ALF_PORTAL, AlfheimPortalBlockEntity::commonTick);
	}
}
