/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.entity;

import net.minecraft.class_1068;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5602;
import net.minecraft.class_5617;
import net.minecraft.class_572;
import net.minecraft.class_5944;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.minecraft.class_909;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.client.core.helper.CoreShaders;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.model.armor.ArmorModels;
import vazkii.botania.common.entity.GaiaGuardianEntity;

public class GaiaGuardianRenderer extends class_909<GaiaGuardianEntity, class_572<GaiaGuardianEntity>> {

	public static final float DEFAULT_GRAIN_INTENSITY = 0.05F;
	public static final float DEFAULT_DISFIGURATION = 0.025F;

	private final Model normalModel;
	private final Model slimModel;

	public GaiaGuardianRenderer(class_5617.class_5618 ctx) {
		super(ctx, new Model(ctx.method_32167(class_5602.field_27577)), 0F);
		this.normalModel = (Model) this.method_4038();
		this.slimModel = new Model(ctx.method_32167(class_5602.field_27581));
		// Call this here bc no other place with access to Context
		ArmorModels.init(ctx);
	}

	@Override
	public void render(@NotNull GaiaGuardianEntity dopple, float yaw, float partialTicks, class_4587 ms, class_4597 buffers, int light) {
		int invulTime = dopple.getInvulTime();
		class_5944 shader = CoreShaders.doppleganger();
		if (shader != null) {
			float grainIntensity, disfiguration;
			if (invulTime > 0) {
				grainIntensity = invulTime > 20 ? 1F : invulTime * 0.05F;
				disfiguration = grainIntensity * 0.3F;
			} else {
				disfiguration = (0.025F + dopple.field_6235 * ((1F - 0.15F) / 20F)) / 2F;
				grainIntensity = 0.05F + dopple.field_6235 * ((1F - 0.15F) / 10F);
			}
			shader.method_35785("BotaniaGrainIntensity").method_1251(grainIntensity);
			shader.method_35785("BotaniaDisfiguration").method_1251(disfiguration);
		}

		var view = class_310.method_1551().method_1560();
		if (view instanceof class_742 && class_1068.method_4647(view.method_5667()).equals("slim")) {
			this.field_4737 = slimModel;
		} else {
			this.field_4737 = normalModel;
		}

		super.method_4072(dopple, yaw, partialTicks, ms, buffers, light);
	}

	@NotNull
	@Override
	public class_2960 getTextureLocation(@NotNull GaiaGuardianEntity entity) {
		class_310 mc = class_310.method_1551();

		if (!(mc.method_1560() instanceof class_742 clientPlayer)) {
			return class_1068.method_4648(entity.method_5667());
		}

		return clientPlayer.method_3117();
	}

	@Override
	protected boolean isBodyVisible(GaiaGuardianEntity dopple) {
		return true;
	}

	private static class Model extends class_572<GaiaGuardianEntity> {
		Model(class_630 root) {
			super(root, RenderHelper::getDopplegangerLayer);
		}
	}

}
