package vazkii.botania.api.configdata;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_6007;
import net.minecraft.class_6008;
import net.minecraft.class_7923;

public class LooniumMobSpawnData extends class_6008.class_6009 {
	public static final Codec<LooniumMobSpawnData> CODEC = RecordCodecBuilder.create(
			instance -> instance.group(
					class_7923.field_41177.method_39673().fieldOf("type").forGetter(msd -> msd.type),
					class_6007.field_29927.fieldOf("weight").forGetter(class_6009::method_34979),
					Codec.BOOL.optionalFieldOf("spawnAsBaby").forGetter(msd -> Optional.ofNullable(msd.spawnAsBaby)),
					class_2487.field_25128.optionalFieldOf("nbt").forGetter(msd -> Optional.ofNullable(msd.nbt)),
					class_2960.field_25139.optionalFieldOf("equipmentTable")
							.forGetter(msd -> Optional.ofNullable(msd.equipmentTable)),
					Codec.list(LooniumMobEffectToApply.CODEC)
							.optionalFieldOf("effectsToApply")
							.forGetter(msd -> Optional.ofNullable(msd.effectsToApply)),
					Codec.list(LooniumMobAttributeModifier.CODEC)
							.optionalFieldOf("attributeModifiers")
							.forGetter(msd -> Optional.ofNullable(msd.attributeModifiers))
			).apply(instance, LooniumMobSpawnData::create)
	);

	public final class_1299<?> type;
	public final Boolean spawnAsBaby;
	public final class_2487 nbt;
	public final class_2960 equipmentTable;
	public final List<LooniumMobEffectToApply> effectsToApply;
	public final List<LooniumMobAttributeModifier> attributeModifiers;

	private LooniumMobSpawnData(class_1299<?> type, class_6007 weight, Boolean spawnAsBaby, @Nullable class_2487 nbt,
			@Nullable class_2960 equipmentTable,
			@Nullable List<LooniumMobEffectToApply> effectsToApply,
			@Nullable List<LooniumMobAttributeModifier> attributeModifiers) {
		super(weight);
		this.type = type;
		this.spawnAsBaby = spawnAsBaby;
		this.nbt = nbt != null ? nbt.method_10553() : null;
		this.equipmentTable = equipmentTable;
		this.effectsToApply = effectsToApply != null ? ImmutableList.copyOf(effectsToApply) : null;
		this.attributeModifiers = attributeModifiers != null ? ImmutableList.copyOf(attributeModifiers) : null;
	}

	public static Builder entityWeight(class_1299<?> type, int weight) {
		return new Builder(type, weight);
	}

	@Override
	public String toString() {
		return "MobSpawnData{" +
				"type=" + type +
				", spawnAsBaby=" + spawnAsBaby +
				", nbt=" + nbt +
				", equipmentTable=" + equipmentTable +
				", effectsToApply=" + effectsToApply +
				", attributeModifiers=" + attributeModifiers +
				'}';
	}

	// Codecs don't support setting null as intentional default value for optional fields, so we do this.
	// (blame com.mojang.datafixers.util.Either::getLeft using Optional::of instead Optional.ofNullable)
	@SuppressWarnings("OptionalUsedAsFieldOrParameterType")
	private static LooniumMobSpawnData create(class_1299<?> type, class_6007 weight,
			Optional<Boolean> spawnAsBaby,
			Optional<class_2487> nbt,
			Optional<class_2960> equipmentTable,
			Optional<List<LooniumMobEffectToApply>> effectsToApply,
			Optional<List<LooniumMobAttributeModifier>> attributeModifiers) {
		return new LooniumMobSpawnData(type, weight,
				spawnAsBaby.orElse(null),
				nbt.orElse(null),
				equipmentTable.orElse(null),
				effectsToApply.orElse(null),
				attributeModifiers.orElse(null));
	}

	public static class Builder {
		private final class_1299<?> type;
		private final int weight;
		private @Nullable Boolean spawnAsBaby;
		private @Nullable class_2487 nbt;
		private @Nullable class_2960 equipmentTable;
		private @Nullable List<LooniumMobEffectToApply> effectsToApply;
		private @Nullable List<LooniumMobAttributeModifier> attributeModifiers;

		private Builder(class_1299<?> type, int weight) {
			this.type = type;
			this.weight = weight;
		}

		/**
		 * Make the mob spawn as a baby. (This will not prevent AgeableMobs from growing up.)
		 */
		public Builder spawnAsBaby() {
			this.spawnAsBaby = true;
			return this;
		}

		/**
		 * Force conversion of a baby mob to be reverted. This may have unintended side effects,
		 * like an adult zombie sitting on a chicken or an adult piglin not having a weapon.
		 * The latter case can usually be taken care of via an equipment table.
		 */
		public Builder spawnAsAdult() {
			this.spawnAsBaby = false;
			return this;
		}

		/**
		 * Custom NBT data to apply to the mob before finalizing its spawning.
		 */
		public Builder nbt(class_2487 nbt) {
			this.nbt = nbt;
			return this;
		}

		/**
		 * A loot table to define equipment to apply to the mob after it spawned.
		 */
		public Builder equipmentTable(class_2960 equipmentTable) {
			this.equipmentTable = equipmentTable;
			return this;
		}

		/**
		 * A list of potion effects to apply to the mob.
		 * (These are applied instead of any mob effects from the structure configuration.)
		 */
		public Builder effectsToApply(LooniumMobEffectToApply... effectsToApply) {
			this.effectsToApply = List.of(effectsToApply);
			return this;
		}

		/**
		 * A list of attribute modifiers to apply to the mob.
		 * (These are applied instead of any attribute modifiers from the structure configuration.)
		 */
		public Builder attributeModifiers(LooniumMobAttributeModifier... attributeModifiers) {
			this.attributeModifiers = List.of(attributeModifiers);
			return this;
		}

		public LooniumMobSpawnData build() {
			return new LooniumMobSpawnData(type, class_6007.method_34977(weight), spawnAsBaby, nbt, equipmentTable,
					effectsToApply, attributeModifiers);
		}
	}
}
