/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.fabric.mixin;

import com.google.common.collect.ImmutableSet;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

import vazkii.botania.common.item.BotaniaItems;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2073;

@Mixin(class_2073.class)
public abstract class ItemPredicateFabricMixin {
	@ModifyVariable(at = @At("HEAD"), method = "<init>(Lnet/minecraft/tags/TagKey;Ljava/util/Set;Lnet/minecraft/advancements/critereon/MinMaxBounds$Ints;Lnet/minecraft/advancements/critereon/MinMaxBounds$Ints;[Lnet/minecraft/advancements/critereon/EnchantmentPredicate;[Lnet/minecraft/advancements/critereon/EnchantmentPredicate;Lnet/minecraft/world/item/alchemy/Potion;Lnet/minecraft/advancements/critereon/NbtPredicate;)V", argsOnly = true)
	private static Set<class_1792> addBotaniaShears(Set<class_1792> set) {
		if (set != null && set.contains(class_1802.field_8868)) {
			set = new HashSet<>(set);
			set.add(BotaniaItems.manasteelShears);
			set.add(BotaniaItems.elementiumShears);
			set = ImmutableSet.copyOf(set);
		}
		return set;
	}
}
