/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.bauble;

import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import vazkii.botania.client.lib.ResourcesLib;
import vazkii.botania.common.helper.ItemNBTHelper;

public class PlanestridersSashItem extends SojournersSashItem {

	private static final class_2960 texture = new class_2960(ResourcesLib.MODEL_SPEED_UP_BELT);

	private static final String TAG_SPEED = "speed";
	private static final String TAG_OLD_X = "oldX";
	private static final String TAG_OLD_Y = "oldY";
	private static final String TAG_OLD_Z = "oldZ";

	public PlanestridersSashItem(class_1793 props) {
		super(props, 0F, 0.2F, 2F);
	}

	@Override
	public class_2960 getRenderTexture() {
		return texture;
	}

	@Override
	public float getSpeed(class_1799 stack) {
		return ItemNBTHelper.getFloat(stack, TAG_SPEED, 0F);
	}

	@Override
	public void onMovedTick(class_1799 stack, class_1657 player) {
		float speed = getSpeed(stack);
		float newspeed = Math.min(0.25F, speed + 0.00035F);
		ItemNBTHelper.setFloat(stack, TAG_SPEED, newspeed);
		commitPositionAndCompare(stack, player);
	}

	@Override
	public void onNotMovingTick(class_1799 stack, class_1657 player) {
		if (!commitPositionAndCompare(stack, player)) {
			ItemNBTHelper.setFloat(stack, TAG_SPEED, 0F);
		}
	}

	public boolean commitPositionAndCompare(class_1799 stack, class_1657 player) {
		double oldX = ItemNBTHelper.getDouble(stack, TAG_OLD_X, 0);
		double oldY = ItemNBTHelper.getDouble(stack, TAG_OLD_Y, 0);
		double oldZ = ItemNBTHelper.getDouble(stack, TAG_OLD_Z, 0);

		ItemNBTHelper.setDouble(stack, TAG_OLD_X, player.method_23317());
		ItemNBTHelper.setDouble(stack, TAG_OLD_Y, player.method_23318());
		ItemNBTHelper.setDouble(stack, TAG_OLD_Z, player.method_23321());

		return Math.abs(oldX - player.method_23317()) > 0.001 || Math.abs(oldY - player.method_23318()) > 0.001 || Math.abs(oldZ - player.method_23321()) > 0.001;
	}

}
