/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1662;
import net.minecraft.class_1703;
import net.minecraft.class_1714;
import net.minecraft.class_1729;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1869;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2955;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3914;
import net.minecraft.class_3956;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4599;
import net.minecraft.class_4608;
import net.minecraft.class_747;
import net.minecraft.class_811;
import net.minecraft.class_8566;
import net.minecraft.util.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.gui.crafting.AssemblyHaloContainer;
import vazkii.botania.client.lib.ResourcesLib;
import vazkii.botania.common.annotations.SoftImplement;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.BotaniaEffectPacket;
import vazkii.botania.xplat.XplatAbstractions;

public class AssemblyHaloItem extends class_1792 {

	private static final class_2960 glowTexture = new class_2960(ResourcesLib.MISC_GLOW_GREEN);
	private static final class_1799 craftingTable = new class_1799(class_2246.field_9980);

	public static final int SEGMENTS = 12;

	private static final String TAG_LAST_CRAFTING = "lastCrafting";
	private static final String TAG_STORED_RECIPE_PREFIX = "storedRecipe";
	private static final String TAG_EQUIPPED = "equipped";
	private static final String TAG_ROTATION_BASE = "rotationBase";

	public AssemblyHaloItem(class_1793 props) {
		super(props);
	}

	@NotNull
	@Override
	public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @NotNull class_1268 hand) {
		class_1799 stack = player.method_5998(hand);
		if (!world.field_9236) {
			int segment = getSegmentLookedAt(stack, player);
			class_1860<?> recipe = getSavedRecipe(world, stack, segment);

			if (segment == 0) {
				// Pos is never used by workbench, so use origin.
				// But this cannot be the static dummy one in the interface, we have to pass an actual one for the
				// crafting matrix to update properly.
				class_3914 wp = class_3914.method_17392(world, class_2338.field_10980);
				player.method_17355(new class_747(
						(windowId, playerInv, p) -> new AssemblyHaloContainer(windowId, playerInv, wp),
						stack.method_7964()));
			} else {
				if (recipe == null) {
					class_1860<?> lastRecipe = getLastRecipe(world, stack);
					if (lastRecipe != null) {
						saveRecipe(stack, lastRecipe.method_8114(), segment);
					}
				} else {
					tryCraft(player, stack, segment, true);
				}
			}
		}

		return class_1271.method_29237(stack, world.method_8608());
	}

	@Override
	public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int pos, boolean equipped) {
		if (!(entity instanceof class_1309 living)) {
			return;
		}

		boolean eqLastTick = wasEquipped(stack);

		if (!equipped && living.method_6079() == stack) {
			equipped = true;
		}

		if (eqLastTick != equipped) {
			setEquipped(stack, equipped);
		}

		if (!equipped) {
			int angles = 360;
			int segAngles = angles / SEGMENTS;
			float shift = segAngles / 2.0F;
			setRotationBase(stack, getCheckingAngle((class_1309) entity) - shift);
		}
	}

	private static boolean hasRoomFor(class_1661 inv, class_1799 stack) {
		class_1661 dummy = new class_1661(inv.field_7546);
		for (int i = 0; i < inv.field_7547.size(); i++) {
			dummy.field_7547.set(i, inv.field_7547.get(i).method_7972());
		}
		// warning: must be careful to not cause side effects / dupes with dummy here
		return dummy.method_7394(stack.method_7972());
	}

	private static boolean canCraftHeuristic(class_1657 player, class_1860<class_8566> recipe) {
		class_1662 accounter = new class_1662();
		player.method_31548().method_7387(accounter);
		return accounter.method_7402(recipe, null);
	}

	void tryCraft(class_1657 player, class_1799 halo, int slot, boolean particles) {
		class_1860<class_8566> recipe = getSavedRecipe(player.method_37908(), halo, slot);
		if (recipe == null) {
			return;
		}

		class_1714 dummy = new class_1714(-999, player.method_31548());
		class_8566 craftInv = (class_8566) dummy.method_7611(1).field_7871;
		RecipePlacer placer = new RecipePlacer(dummy);

		// Try placing the recipe into the dummy workbench, extracting items from player's inventory to do so
		if (!placer.place((class_3222) player, recipe)) {
			return;
		}

		// Double check that the recipe matches
		if (!recipe.method_8115(craftInv, player.method_37908())) {
			// If the placer worked but the recipe still didn't, this might be a dynamic recipe with special conditions.
			// Return items to the inventory and bail.
			placer.method_12822();
			return;
		}

		class_1799 result = recipe.method_8116(craftInv, player.method_37908().method_30349());

		// Check if we have room for the result
		if (!hasRoomFor(player.method_31548(), result)) {
			placer.method_12822();
			return;
		}

		// Now we are good to go. Give the result
		player.method_31548().method_7394(result);

		// Give or toss all byproducts
		class_2371<class_1799> remainingItems = recipe.method_8111(craftInv);
		remainingItems.forEach(s -> player.method_31548().method_7398(s));

		// The items we consumed will stay in the dummy workbench and get deleted

		if (particles) {
			XplatAbstractions.INSTANCE.sendToTracking(player, new BotaniaEffectPacket(EffectType.HALO_CRAFT,
					player.method_23317(), player.method_23318(), player.method_23321(), player.method_5628()));
		}
	}

	@SoftImplement("IForgeItem")
	public boolean onEntitySwing(class_1799 stack, class_1309 living) {
		int segment = getSegmentLookedAt(stack, living);
		if (segment == 0) {
			return false;
		}

		class_1860<?> recipe = getSavedRecipe(living.method_37908(), stack, segment);
		if (recipe != null && living.method_5715()) {
			saveRecipe(stack, null, segment);
			return true;
		}

		return false;
	}

	protected static int getSegmentLookedAt(class_1799 stack, class_1309 living) {
		float yaw = getCheckingAngle(living, getRotationBase(stack));

		int angles = 360;
		int segAngles = angles / SEGMENTS;
		for (int seg = 0; seg < SEGMENTS; seg++) {
			float calcAngle = (float) seg * segAngles;
			if (yaw >= calcAngle && yaw < calcAngle + segAngles) {
				return seg;
			}
		}
		return -1;
	}

	private static float getCheckingAngle(class_1309 living) {
		return getCheckingAngle(living, 0F);
	}

	// Screw the way minecraft handles rotation
	// Really...
	private static float getCheckingAngle(class_1309 living, float base) {
		float yaw = class_3532.method_15393(living.method_36454()) + 90F;
		int angles = 360;
		int segAngles = angles / SEGMENTS;
		float shift = segAngles / 2;

		if (yaw < 0) {
			yaw = 180F + (180F + yaw);
		}
		yaw -= 360F - base;
		float angle = 360F - yaw + shift;

		if (angle < 0) {
			angle = 360F + angle;
		}

		return angle;
	}

	@Nullable
	private static class_1860<class_8566> getSavedRecipe(class_1937 world, class_1799 halo, int position) {
		String savedId = ItemNBTHelper.getString(halo, TAG_STORED_RECIPE_PREFIX + position, "");
		class_2960 id = savedId.isEmpty() ? null : class_2960.method_12829(savedId);

		if (position <= 0 || position >= SEGMENTS || id == null) {
			return null;
		} else {
			return BotaniaRecipeTypes.getRecipes(world, class_3956.field_17545).get(id);
		}
	}

	private static void saveRecipe(class_1799 halo, @Nullable class_2960 id, int position) {
		if (id == null) {
			ItemNBTHelper.removeEntry(halo, TAG_STORED_RECIPE_PREFIX + position);
		} else {
			ItemNBTHelper.setString(halo, TAG_STORED_RECIPE_PREFIX + position, id.toString());
		}
	}

	private static class_1799 getDisplayItem(class_1937 world, class_1799 stack, int position) {
		if (position == 0) {
			return craftingTable;
		} else if (position >= SEGMENTS) {
			return class_1799.field_8037;
		} else {
			class_1860<?> recipe = getSavedRecipe(world, stack, position);
			if (recipe != null) {
				return recipe.method_8110(world.method_30349());
			} else {
				return class_1799.field_8037;
			}
		}
	}

	public static void onItemCrafted(class_1657 player, class_1263 inv) {
		class_1703 container = player.field_7512;

		if (!(container instanceof AssemblyHaloContainer) ||
				!(inv instanceof class_8566 cc)) {
			return;
		}

		player.method_37908().method_8433().method_8132(class_3956.field_17545, cc, player.method_37908()).ifPresent(recipe -> {
			for (int i = 0; i < player.method_31548().method_5439(); i++) {
				class_1799 stack = player.method_31548().method_5438(i);
				if (!stack.method_7960() && stack.method_7909() instanceof AssemblyHaloItem) {
					rememberLastRecipe(recipe.method_8114(), stack);
				}
			}
		});
	}

	private static void rememberLastRecipe(class_2960 recipeId, class_1799 halo) {
		ItemNBTHelper.setString(halo, TAG_LAST_CRAFTING, recipeId.toString());
	}

	@Nullable
	private static class_1860<class_8566> getLastRecipe(class_1937 world, class_1799 halo) {
		String savedId = ItemNBTHelper.getString(halo, TAG_LAST_CRAFTING, "");
		class_2960 id = savedId.isEmpty() ? null : class_2960.method_12829(savedId);

		return BotaniaRecipeTypes.getRecipes(world, class_3956.field_17545).get(id);
	}

	private static boolean wasEquipped(class_1799 stack) {
		return ItemNBTHelper.getBoolean(stack, TAG_EQUIPPED, false);
	}

	private static void setEquipped(class_1799 stack, boolean equipped) {
		ItemNBTHelper.setBoolean(stack, TAG_EQUIPPED, equipped);
	}

	private static float getRotationBase(class_1799 stack) {
		return ItemNBTHelper.getFloat(stack, TAG_ROTATION_BASE, 0F);
	}

	private static void setRotationBase(class_1799 stack, float rotation) {
		ItemNBTHelper.setFloat(stack, TAG_ROTATION_BASE, rotation);
	}

	public class_2960 getGlowResource(class_1799 stack) {
		return glowTexture;
	}

	public static class Rendering {
		public static void onRenderWorldLast(class_4184 camera, float partialTicks, class_4587 ms, class_4599 buffers) {
			class_1657 player = class_310.method_1551().field_1724;
			class_1799 stack = PlayerHelper.getFirstHeldItemClass(player, AssemblyHaloItem.class);
			if (stack.method_7960()) {
				return;
			}

			class_4597.class_4598 bufferSource = buffers.method_23000();

			double renderPosX = camera.method_19326().method_10216();
			double renderPosY = camera.method_19326().method_10214();
			double renderPosZ = camera.method_19326().method_10215();

			ms.method_22903();
			float alpha = ((float) Math.sin((ClientTickHandler.ticksInGame + partialTicks) * 0.2F) * 0.5F + 0.5F) * 0.4F + 0.3F;

			double posX = player.field_6014 + (player.method_23317() - player.field_6014) * partialTicks;
			double posY = player.field_6036 + (player.method_23318() - player.field_6036) * partialTicks + player.method_5751();
			double posZ = player.field_5969 + (player.method_23321() - player.field_5969) * partialTicks;

			ms.method_22904(posX - renderPosX, posY - renderPosY, posZ - renderPosZ);

			float base = getRotationBase(stack);
			int angles = 360;
			int segAngles = angles / SEGMENTS;
			float shift = base - segAngles / 2.0F;

			float u = 1F;
			float v = 0.25F;

			float s = 3F;
			float m = 0.8F;
			float y = v * s * 2;
			float y0 = 0;

			int segmentLookedAt = getSegmentLookedAt(stack, player);
			AssemblyHaloItem item = (AssemblyHaloItem) stack.method_7909();
			class_1921 layer = RenderHelper.getHaloLayer(item.getGlowResource(stack));

			for (int seg = 0; seg < SEGMENTS; seg++) {
				boolean inside = false;
				float rotationAngle = (seg + 0.5F) * segAngles + shift;
				ms.method_22903();
				ms.method_22907(VecHelper.rotateY(rotationAngle));
				ms.method_46416(s * m, -0.75F, 0F);

				if (segmentLookedAt == seg) {
					inside = true;
				}

				class_1799 slotStack = getDisplayItem(player.method_37908(), stack, seg);
				if (!slotStack.method_7960()) {
					float scale = seg == 0 ? 0.9F : 0.8F;
					ms.method_22905(scale, scale, scale);
					ms.method_22907(VecHelper.rotateY(180F));
					ms.method_46416(seg == 0 ? 0.5F : 0F, seg == 0 ? -0.1F : 0.6F, 0F);

					ms.method_22907(VecHelper.rotateY(90.0F));
					class_310.method_1551().method_1480().method_23178(slotStack, class_811.field_4317,
							0xF000F0, class_4608.field_21444, ms, bufferSource, player.method_37908(), player.method_5628());
				}
				ms.method_22909();

				ms.method_22903();
				ms.method_22907(VecHelper.rotateX(180));
				float r = 1, g = 1, b = 1, a = alpha;
				if (inside) {
					a += 0.3F;
					y0 = -y;
				}

				if (seg % 2 == 0) {
					r = g = b = 0.6F;
				}

				class_4588 buffer = bufferSource.getBuffer(layer);
				for (int i = 0; i < segAngles; i++) {
					Matrix4f mat = ms.method_23760().method_23761();
					float ang = i + seg * segAngles + shift;
					float xp = (float) Math.cos(ang * Math.PI / 180F) * s;
					float zp = (float) Math.sin(ang * Math.PI / 180F) * s;

					buffer.method_22918(mat, xp * m, y, zp * m).method_22915(r, g, b, a).method_22913(u, v).method_1344();
					buffer.method_22918(mat, xp, y0, zp).method_22915(r, g, b, a).method_22913(u, 0).method_1344();

					xp = (float) Math.cos((ang + 1) * Math.PI / 180F) * s;
					zp = (float) Math.sin((ang + 1) * Math.PI / 180F) * s;

					buffer.method_22918(mat, xp, y0, zp).method_22915(r, g, b, a).method_22913(0, 0).method_1344();
					buffer.method_22918(mat, xp * m, y, zp * m).method_22915(r, g, b, a).method_22913(0, v).method_1344();
				}
				y0 = 0;
				ms.method_22909();
			}
			ms.method_22909();
			bufferSource.method_22993();
		}

		public static void renderHUD(class_332 gui, class_1657 player, class_1799 stack) {
			class_310 mc = class_310.method_1551();
			int slot = getSegmentLookedAt(stack, player);

			if (slot == 0) {
				String name = craftingTable.method_7964().getString();
				int l = mc.field_1772.method_1727(name);
				int x = mc.method_22683().method_4486() / 2 - l / 2;
				int y = mc.method_22683().method_4502() / 2 - 65;

				gui.method_25294(x - 6, y - 6, x + l + 6, y + 37, 0x22000000);
				gui.method_25294(x - 4, y - 4, x + l + 4, y + 35, 0x22000000);
				gui.method_51427(craftingTable, mc.method_22683().method_4486() / 2 - 8, mc.method_22683().method_4502() / 2 - 52);

				gui.method_25303(mc.field_1772, name, x, y, 0xFFFFFF);
			} else {
				class_1860<class_8566> recipe = getSavedRecipe(player.method_37908(), stack, slot);
				class_2561 label;
				boolean setRecipe = false;

				if (recipe == null) {
					label = class_2561.method_43471("botaniamisc.unsetRecipe");
					recipe = getLastRecipe(player.method_37908(), stack);
				} else {
					label = recipe.method_8110(player.method_37908().method_30349()).method_7964();
					setRecipe = true;
				}

				renderRecipe(gui, label, recipe, player, setRecipe);
			}
		}

		private static void renderRecipe(class_332 gui, class_2561 label, @Nullable class_1860<class_8566> recipe, class_1657 player, boolean isSavedRecipe) {
			class_310 mc = class_310.method_1551();

			class_1799 recipeResult;
			if (recipe != null && !(recipeResult = recipe.method_8110(player.method_37908().method_30349())).method_7960()) {
				int x = mc.method_22683().method_4486() / 2 - 45;
				int y = mc.method_22683().method_4502() / 2 - 90;

				gui.method_25294(x - 6, y - 6, x + 90 + 6, y + 60, 0x22000000);
				gui.method_25294(x - 4, y - 4, x + 90 + 4, y + 58, 0x22000000);

				gui.method_25294(x + 66, y + 14, x + 92, y + 40, 0x22000000);
				gui.method_25294(x - 2, y - 2, x + 56, y + 56, 0x22000000);

				int wrap = recipe instanceof class_1869 shaped ? shaped.method_8150() : 3;
				for (int i = 0; i < recipe.method_8117().size(); i++) {
					class_1856 ingr = recipe.method_8117().get(i);
					if (ingr != class_1856.field_9017) {
						class_1799 stack = ingr.method_8105()[ClientTickHandler.ticksInGame / 20 % ingr.method_8105().length];
						int xpos = x + i % wrap * 18;
						int ypos = y + i / wrap * 18;
						gui.method_25294(xpos, ypos, xpos + 16, ypos + 16, 0x22000000);

						gui.method_51427(stack, xpos, ypos);
					}
				}

				gui.method_51427(recipeResult, x + 72, y + 18);
				gui.method_51431(mc.field_1772, recipeResult, x + 72, y + 18);

			}

			int yoff = 110;
			if (isSavedRecipe && recipe != null && !canCraftHeuristic(player, recipe)) {
				String warning = class_124.field_1061 + class_1074.method_4662("botaniamisc.cantCraft");
				gui.method_25300(mc.field_1772, warning, mc.method_22683().method_4486() / 2, mc.method_22683().method_4502() / 2 - yoff, 0xFFFFFF);
				yoff += 12;
			}

			gui.method_27534(mc.field_1772, label, mc.method_22683().method_4486() / 2, mc.method_22683().method_4502() / 2 - yoff, 0xFFFFFF);
		}
	}

	public static class RecipePlacer extends class_2955<class_8566> {
		public RecipePlacer(class_1729<class_8566> container) {
			super(container);
		}

		// [VanillaCopy] Based on super.recipeClicked
		public boolean place(class_3222 player, @Nullable class_1860<class_8566> recipe) {
			if (recipe != null) {
				this.field_13350 = player.method_31548();
				this.field_13347.method_7409();
				player.method_31548().method_7387(this.field_13347);
				this.field_13348.method_7654(this.field_13347);

				boolean ret;
				if (this.field_13347.method_7402(recipe, null)) {
					this.method_12821(recipe, false);
					ret = true;
				} else {
					this.method_12822();
					ret = false;
				}

				player.method_31548().method_5431();
				return ret;
			}
			return false;
		}

		// Make public
		@Override
		public void method_12822() {
			super.method_12822();
		}
	}
}
