/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting.recipe;

import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_8566;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.item.CosmeticAttachable;
import vazkii.botania.api.item.CosmeticBauble;

public class CosmeticAttachRecipe extends class_1852 {
	public static final NoOpRecipeSerializer<CosmeticAttachRecipe> SERIALIZER = new NoOpRecipeSerializer<>(CosmeticAttachRecipe::new);

	public CosmeticAttachRecipe(class_2960 id) {
		super(id, class_7710.field_40250);
	}

	@Override
	public boolean matches(@NotNull class_8566 inv, @NotNull class_1937 world) {
		boolean foundCosmetic = false;
		boolean foundAttachable = false;

		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 stack = inv.method_5438(i);
			if (!stack.method_7960()) {
				if (stack.method_7909() instanceof CosmeticBauble && !foundCosmetic) {
					foundCosmetic = true;
				} else if (!foundAttachable) {
					if (stack.method_7909() instanceof CosmeticAttachable attachable && !(stack.method_7909() instanceof CosmeticBauble) && attachable.getCosmeticItem(stack).method_7960()) {
						foundAttachable = true;
					} else {
						return false;
					}
				}
			}
		}

		return foundCosmetic && foundAttachable;
	}

	@NotNull
	@Override
	public class_1799 assemble(@NotNull class_8566 inv, @NotNull class_5455 registries) {
		class_1799 cosmeticItem = class_1799.field_8037;
		class_1799 attachableItem = class_1799.field_8037;

		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 stack = inv.method_5438(i);
			if (!stack.method_7960()) {
				if (stack.method_7909() instanceof CosmeticBauble && cosmeticItem.method_7960()) {
					cosmeticItem = stack;
				} else {
					attachableItem = stack;
				}
			}
		}

		if (!(attachableItem.method_7909() instanceof CosmeticAttachable attachable)) {
			return class_1799.field_8037;
		}

		if (!attachable.getCosmeticItem(attachableItem).method_7960()) {
			return class_1799.field_8037;
		}

		class_1799 copy = attachableItem.method_7972();
		attachable.setCosmeticItem(copy, cosmeticItem);
		return copy;
	}

	@Override
	public boolean method_8113(int width, int height) {
		return width * height >= 2;
	}

	@NotNull
	@Override
	public class_1865<?> method_8119() {
		return SERIALIZER;
	}
}
