/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.block_entity;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.proxy.Proxy;

public class StarfieldCreatorBlockEntity extends BotaniaBlockEntity {
	public StarfieldCreatorBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaBlockEntities.STARFIELD, pos, state);
	}

	public static void clientTick(class_1937 level, class_2338 worldPosition, class_2680 state, StarfieldCreatorBlockEntity self) {
		level.method_8533(); // this isn't called often on clients, but we need so that isDay is accurate.
		if (level.method_8530()) {
			return;
		}

		double radius = 512;
		int iter = 2;
		for (int i = 0; i < iter; i++) {
			double x = worldPosition.method_10263() + 0.5 + (Math.random() - 0.5) * radius;
			double y = Math.min(256, worldPosition.method_10264() + Proxy.INSTANCE.getClientRenderDistance() * 16);
			double z = worldPosition.method_10260() + 0.5 + (Math.random() - 0.5) * radius;

			float w = 0.6F;
			float c = 1F - w;

			float r = w + (float) Math.random() * c;
			float g = w + (float) Math.random() * c;
			float b = w + (float) Math.random() * c;

			float s = 20F + (float) Math.random() * 20F;
			int m = 50;

			SparkleParticleData data = SparkleParticleData.sparkle(s, r, g, b, m);
			level.method_8466(data, true, x, y, z, 0, 0, 0);
		}
	}

}
