/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.advancements;

import com.google.gson.JsonObject;

import net.minecraft.advancements.critereon.*;
import net.minecraft.class_1799;
import net.minecraft.class_195;
import net.minecraft.class_2048;
import net.minecraft.class_2073;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5257;
import net.minecraft.class_5258;
import net.minecraft.class_5267;
import org.jetbrains.annotations.NotNull;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class ManaBlasterTrigger extends class_4558<ManaBlasterTrigger.Instance> {
	private static final class_2960 ID = prefix("fire_mana_blaster");
	public static final ManaBlasterTrigger INSTANCE = new ManaBlasterTrigger();

	private ManaBlasterTrigger() {}

	@NotNull
	@Override
	public class_2960 method_794() {
		return ID;
	}

	@NotNull
	@Override
	public ManaBlasterTrigger.Instance method_27854(@NotNull JsonObject json, class_5258 playerPred, class_5257 conditions) {
		return new ManaBlasterTrigger.Instance(playerPred, class_2073.method_8969(json.get("item")),
				class_2048.method_8913(json.get("user")));
	}

	public void trigger(class_3222 player, class_1799 stack) {
		method_22510(player, instance -> instance.test(stack, player));
	}

	public static class Instance extends class_195 {
		private final class_2073 item;
		private final class_2048 user;

		public Instance(class_5258 entityPred, class_2073 count, class_2048 user) {
			super(ID, entityPred);
			this.item = count;
			this.user = user;
		}

		@NotNull
		@Override
		public class_2960 method_806() {
			return ID;
		}

		boolean test(class_1799 stack, class_3222 entity) {
			return this.item.method_8970(stack) && this.user.method_8914(entity, entity);
		}

		@Override
		public JsonObject method_807(class_5267 context) {
			JsonObject json = super.method_807(context);
			if (item != class_2073.field_9640) {
				json.add("item", item.method_8971());
			}
			if (user != class_2048.field_9599) {
				json.add("user", user.method_8912());
			}
			return json;
		}

		public class_2073 getItem() {
			return this.item;
		}

		public class_2048 getUser() {
			return this.user;
		}
	}
}
