/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.block_entity;

import net.minecraft.class_1087;
import net.minecraft.class_1921;
import net.minecraft.class_2741;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_776;
import net.minecraft.class_827;
import vazkii.botania.common.block.block_entity.mana.ManaPumpBlockEntity;
import vazkii.botania.common.helper.VecHelper;

public class ManaPumpBlockEntityRenderer implements class_827<ManaPumpBlockEntity> {
	public static class_1087 headModel = null;
	private final class_776 blockRenderDispatcher;

	public ManaPumpBlockEntityRenderer(class_5614.class_5615 ctx) {
		this.blockRenderDispatcher = ctx.method_32141();
	}

	@Override
	public void render(ManaPumpBlockEntity pump, float partialTicks, class_4587 ms, class_4597 buffers, int light, int overlay) {
		ms.method_22903();
		ms.method_22904(0.5, 0, 0.5);
		float angle = 0;
		switch (pump.method_11010().method_11654(class_2741.field_12481)) {
			default:
			case field_11043:
				break;
			case field_11035:
				angle = 180;
				break;
			case field_11034:
				angle = -90;
				break;
			case field_11039:
				angle = 90;
				break;
		}
		ms.method_22907(VecHelper.rotateY(angle));
		ms.method_22904(-0.5, 0, -0.5);
		double diff = Math.max(0F, Math.min(8F, pump.innerRingPos + pump.moving * partialTicks));
		ms.method_22904(0, 0, diff / 14);
		class_4588 buffer = buffers.getBuffer(class_1921.method_23577());
		blockRenderDispatcher.method_3350().method_3367(ms.method_23760(), buffer, null, headModel, 1, 1, 1, light, overlay);
		ms.method_22909();
	}
}
