/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.fx;

import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2960;
import net.minecraft.class_4002;
import net.minecraft.class_707;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class BotaniaParticles {
	public static final class_2396<WispParticleData> WISP = new WispParticleType();
	public static final class_2396<SparkleParticleData> SPARKLE = new SparkleParticleType();

	public static void registerParticles(BiConsumer<class_2396<?>, class_2960> r) {
		r.accept(WISP, prefix("wisp"));
		r.accept(SPARKLE, prefix("sparkle"));
	}

	public static class FactoryHandler {
		public interface Consumer {
			<T extends class_2394> void register(class_2396<T> type, Function<class_4002, class_707<T>> constructor);
		}

		public static void registerFactories(Consumer consumer) {
			consumer.register(BotaniaParticles.WISP, WispParticleType.Factory::new);
			consumer.register(BotaniaParticles.SPARKLE, SparkleParticleType.Factory::new);
		}
	}
}
