/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.functional;

import com.google.common.base.Suppliers;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMaps;
import it.unimi.dsi.fastutil.objects.Object2BooleanRBTreeMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectBooleanPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1267;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1831;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_270;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_332;
import net.minecraft.class_3449;
import net.minecraft.class_3730;
import net.minecraft.class_3732;
import net.minecraft.class_5134;
import net.minecraft.class_5138;
import net.minecraft.class_52;
import net.minecraft.class_5250;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_60;
import net.minecraft.class_7061;
import net.minecraft.class_7924;
import net.minecraft.class_8567;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.block_entity.BindableSpecialFlowerBlockEntity;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.api.configdata.ConfigDataManager;
import vazkii.botania.api.configdata.LooniumMobAttributeModifier;
import vazkii.botania.api.configdata.LooniumMobEffectToApply;
import vazkii.botania.api.configdata.LooniumMobSpawnData;
import vazkii.botania.api.configdata.LooniumStructureConfiguration;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.internal_caps.LooniumComponent;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.common.loot.BotaniaLootTables;
import vazkii.botania.xplat.XplatAbstractions;

public class LooniumBlockEntity
extends FunctionalFlowerBlockEntity {
    private static final int RANGE = 5;
    private static final int CHECK_RANGE = 9;
    private static final String TAG_LOOT_TABLE = "lootTable";
    private static final String TAG_DETECTED_STRUCTURE = "detectedStructure";
    private static final String TAG_CONFIG_OVERRIDE = "configOverride";
    private static final String TAG_ATTUNE_DISPLAY_OVERRIDE = "attuneDisplayOverride";
    private static final Supplier<LooniumStructureConfiguration> FALLBACK_CONFIG = Suppliers.memoize(() -> LooniumStructureConfiguration.builder().manaCost(35000).maxNearbyMobs(10).boundingBoxType(class_7061.class_7062.field_37199).spawnedMobs(LooniumMobSpawnData.entityWeight(class_1299.field_6051, 1).build()).attributeModifiers(new LooniumMobAttributeModifier[0]).effectsToApply(LooniumMobEffectToApply.effect(class_1294.field_5924).build(), LooniumMobEffectToApply.effect(class_1294.field_5918).build(), LooniumMobEffectToApply.effect(class_1294.field_5907).build(), LooniumMobEffectToApply.effect(class_1294.field_5910).build()).build());
    public static final String LOONIUM_TEAM_NAME = "Loonium Monsters";
    public static final class_270 LOONIUM_TEAM = new class_270(){

        @NotNull
        public String method_1197() {
            return LooniumBlockEntity.LOONIUM_TEAM_NAME;
        }

        @NotNull
        public class_5250 method_1198(class_2561 component) {
            return component.method_27661();
        }

        public boolean method_1199() {
            return true;
        }

        public boolean method_1205() {
            return true;
        }

        @NotNull
        public class_270.class_272 method_1201() {
            return class_270.class_272.field_1442;
        }

        @NotNull
        public class_124 method_1202() {
            return class_124.field_1070;
        }

        @NotNull
        public Collection<String> method_1204() {
            return List.of();
        }

        @NotNull
        public class_270.class_272 method_1200() {
            return class_270.class_272.field_1442;
        }

        @NotNull
        public class_270.class_271 method_1203() {
            return class_270.class_271.field_1437;
        }
    };
    @Nullable
    private class_2960 lootTableOverride;
    @Nullable
    private Object2BooleanMap<class_2960> detectedStructures;
    @Nullable
    private class_2960 configOverride;
    @Nullable
    private String attuneDisplayOverride;

    public LooniumBlockEntity(class_2338 pos, class_2680 state) {
        super(BotaniaFlowerBlocks.LOONIUM, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        class_1937 class_19372 = this.method_10997();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 world = (class_3218)class_19372;
        if (this.detectedStructures == null) {
            this.detectStructure(world);
        }
        if (this.redstoneSignal != 0 || this.ticksExisted % 100 != 0 || world.method_8407() == class_1267.field_5801 || !world.method_37118(this.getEffectivePos())) {
            return;
        }
        ConfigDataManager configData = BotaniaAPI.instance().getConfigData();
        Map<class_2960, LooniumStructureConfiguration> structureConfigs = this.determineStructureConfigs(configData, this.detectedStructures);
        List<Pair<class_2960, class_52>> lootTables = this.determineLootTables(world, structureConfigs.keySet());
        if (lootTables.isEmpty()) {
            return;
        }
        Pair<class_2960, class_52> randomPick = lootTables.get(world.field_9229.method_43048(lootTables.size()));
        LooniumStructureConfiguration pickedConfig = structureConfigs.getOrDefault(randomPick.key(), structureConfigs.get(LooniumStructureConfiguration.DEFAULT_CONFIG_ID));
        class_52 pickedLootTable = (class_52)randomPick.value();
        if (this.getMana() < pickedConfig.manaCost) {
            return;
        }
        int numberOfMobsAround = this.countNearbyMobs(world, pickedConfig);
        if (numberOfMobsAround >= pickedConfig.maxNearbyMobs) {
            return;
        }
        LooniumMobSpawnData pickedMobType = pickedConfig.spawnedMobs.method_34992(world.field_9229).orElse(null);
        if (pickedMobType == null) {
            return;
        }
        this.spawnMob(world, pickedMobType, pickedConfig, pickedLootTable);
    }

    private void spawnMob(class_3218 world, LooniumMobSpawnData pickedMobType, LooniumStructureConfiguration pickedConfig, class_52 pickedLootTable) {
        class_52 equipmentTable;
        class_1799 lootStack = LooniumBlockEntity.pickRandomLootItem(world, pickedLootTable);
        if (lootStack.method_7960()) {
            return;
        }
        class_5819 random = world.field_9229;
        double x = (double)this.getEffectivePos().method_10263() + 0.5 - 5.0 + 10.0 * random.method_43058();
        double y = this.getEffectivePos().method_10264();
        double z = (double)this.getEffectivePos().method_10260() + 0.5 - 5.0 + 10.0 * random.method_43058();
        while (!world.method_18026(pickedMobType.type.method_17683(x, y, z))) {
            if (!((y += 1.0) >= (double)world.method_31600())) continue;
            return;
        }
        class_1297 entity = pickedMobType.type.method_5883((class_1937)world);
        if (!(entity instanceof class_1308)) {
            return;
        }
        class_1308 mob = (class_1308)entity;
        if (pickedMobType.nbt != null) {
            mob.method_5749(pickedMobType.nbt);
        }
        if (pickedMobType.spawnAsBaby != null) {
            mob.method_7217(pickedMobType.spawnAsBaby.booleanValue());
        }
        mob.method_5641(x, y, z, random.method_43057() * 360.0f, 0.0f);
        mob.method_18799(class_243.field_1353);
        LooniumBlockEntity.applyAttributesAndEffects(pickedMobType, pickedConfig, mob);
        LooniumComponent looniumComponent = XplatAbstractions.INSTANCE.looniumComponent((class_1309)mob);
        if (looniumComponent != null) {
            looniumComponent.setSlowDespawn(true);
            looniumComponent.setOverrideDrop(true);
            looniumComponent.setDrop(lootStack);
        }
        mob.method_5943((class_5425)world, world.method_8404(mob.method_24515()), class_3730.field_16469, null, null);
        if (Boolean.FALSE.equals(pickedMobType.spawnAsBaby) && mob.method_6109()) {
            mob.method_7217(false);
        }
        if (pickedMobType.equipmentTable != null && (equipmentTable = world.method_8503().method_3857().getLootTable(pickedMobType.equipmentTable)) != class_52.field_948) {
            class_8567 lootParams = new class_8567.class_8568(world).method_51874(class_181.field_1226, (Object)mob).method_51874(class_181.field_24424, (Object)mob.method_19538()).method_51875(class_173.field_20762);
            HashSet equippedSlots = new HashSet();
            equipmentTable.method_51882(lootParams, equipmentStack -> {
                class_1304 slot;
                class_1304 class_13042 = slot = equipmentStack.method_31573(BotaniaTags.Items.LOONIUM_OFFHAND_EQUIPMENT) ? class_1304.field_6171 : class_1309.method_32326((class_1799)equipmentStack);
                if (equippedSlots.contains(slot)) {
                    class_1304 class_13043 = slot = equippedSlots.contains(class_1304.field_6173) && !(equipmentStack.method_7909() instanceof class_1831) ? class_1304.field_6171 : class_1304.field_6173;
                }
                if (!equippedSlots.add(slot)) {
                    return;
                }
                mob.method_5673(slot, slot.method_46643() ? equipmentStack.method_46651(1) : equipmentStack);
            });
        }
        mob.method_5668().method_31748().forEach(e -> {
            if (e instanceof class_1308) {
                class_1799 bonusLoot;
                class_3732 patroller;
                class_1308 otherMob = (class_1308)e;
                Arrays.stream(class_1304.values()).forEach(slot -> otherMob.method_5946(slot, 0.0f));
                if (mob instanceof class_3732 && (patroller = (class_3732)mob).method_16219()) {
                    patroller.method_16217(false);
                    patroller.method_5673(class_1304.field_6169, class_1799.field_8037);
                }
                if (e == mob) {
                    return;
                }
                Optional<LooniumMobSpawnData> mobType = pickedConfig.spawnedMobs.method_34994().stream().filter(mobSpawnData -> mobSpawnData.type.method_31488((class_1297)otherMob) != null).findFirst();
                if (mobType.isPresent()) {
                    LooniumBlockEntity.applyAttributesAndEffects(mobType.get(), pickedConfig, mob);
                    bonusLoot = LooniumBlockEntity.pickRandomLootItem(world, pickedLootTable);
                } else {
                    bonusLoot = class_1799.field_8037;
                }
                LooniumComponent otherLooniumComponent = XplatAbstractions.INSTANCE.looniumComponent((class_1309)otherMob);
                if (otherLooniumComponent != null) {
                    otherLooniumComponent.setSlowDespawn(true);
                    otherLooniumComponent.setOverrideDrop(true);
                    otherLooniumComponent.setDrop(bonusLoot);
                }
            }
        });
        if (!world.method_30736((class_1297)mob)) {
            return;
        }
        mob.method_5990();
        world.method_20290(2004, this.method_11016(), 0);
        world.method_43275((class_1297)mob, class_5712.field_28738, mob.method_19538());
        this.addMana(-pickedConfig.manaCost.intValue());
        this.sync();
    }

    private static void applyAttributesAndEffects(LooniumMobSpawnData mobSpawnData, LooniumStructureConfiguration pickedConfig, class_1308 mob) {
        List<LooniumMobAttributeModifier> attributeModifiers = mobSpawnData.attributeModifiers != null ? mobSpawnData.attributeModifiers : pickedConfig.attributeModifiers;
        for (LooniumMobAttributeModifier attributeModifier : attributeModifiers) {
            class_1324 attribute = mob.method_5996(attributeModifier.attribute);
            if (attribute == null) continue;
            attribute.method_26837(attributeModifier.createAttributeModifier());
            if (attribute.method_6198() != class_5134.field_23716) continue;
            mob.method_6033(mob.method_6063());
        }
        List<LooniumMobEffectToApply> effectsToApply = mobSpawnData.effectsToApply != null ? mobSpawnData.effectsToApply : pickedConfig.effectsToApply;
        for (LooniumMobEffectToApply effectToApply : effectsToApply) {
            mob.method_6092(effectToApply.createMobEffectInstance());
        }
    }

    private int countNearbyMobs(class_3218 world, LooniumStructureConfiguration pickedConfig) {
        Set setOfMobTypes = pickedConfig.spawnedMobs.method_34994().stream().map(msd -> msd.type).collect(Collectors.toSet());
        return world.method_8390(class_1308.class, new class_238(this.getEffectivePos()).method_1014(9.0), m -> setOfMobTypes.contains(m.method_5864())).size();
    }

    private static class_1799 pickRandomLootItem(class_3218 world, class_52 pickedLootTable) {
        class_8567 params = new class_8567.class_8568(world).method_51875(class_173.field_1175);
        ObjectArrayList stacks = pickedLootTable.method_51879(params, world.field_9229.method_43055());
        stacks.removeIf(s -> s.method_7960() || s.method_31573(BotaniaTags.Items.LOONIUM_BLACKLIST));
        if (stacks.isEmpty()) {
            return class_1799.field_8037;
        }
        Collections.shuffle(stacks);
        return (class_1799)stacks.get(0);
    }

    @NotNull
    private List<Pair<class_2960, class_52>> determineLootTables(class_3218 world, Set<class_2960> structureIds) {
        class_52 defaultLootTable;
        ArrayList<Pair<class_2960, class_52>> lootTables = new ArrayList<Pair<class_2960, class_52>>();
        class_60 lootData = world.method_8503().method_3857();
        com.google.common.base.Supplier defaultLootTableSupplier = Suppliers.memoize(() -> lootData.getLootTable(BotaniaLootTables.LOONIUM_DEFAULT_LOOT));
        if (this.lootTableOverride != null) {
            class_52 lootTable = lootData.getLootTable(this.lootTableOverride);
            if (lootTable != class_52.field_948) {
                lootTables.add((Pair<class_2960, class_52>)Pair.of((Object)LooniumStructureConfiguration.DEFAULT_CONFIG_ID, (Object)lootTable));
            }
        } else {
            for (class_2960 structureId : structureIds) {
                if (structureId.equals((Object)LooniumStructureConfiguration.DEFAULT_CONFIG_ID)) continue;
                class_2960 lootTableId = ResourceLocationHelper.prefix("loonium/%s/%s".formatted(structureId.method_12836(), structureId.method_12832()));
                class_52 lootTable = lootData.getLootTable(lootTableId);
                if (lootTable != class_52.field_948) {
                    lootTables.add((Pair<class_2960, class_52>)Pair.of((Object)structureId, (Object)lootTable));
                    continue;
                }
                class_52 defaultLootTable2 = (class_52)defaultLootTableSupplier.get();
                if (defaultLootTable2 == class_52.field_948) continue;
                lootTables.add((Pair<class_2960, class_52>)Pair.of((Object)structureId, (Object)defaultLootTable2));
            }
        }
        if (lootTables.isEmpty() && (defaultLootTable = (class_52)defaultLootTableSupplier.get()) != class_52.field_948) {
            lootTables.add((Pair<class_2960, class_52>)Pair.of((Object)LooniumStructureConfiguration.DEFAULT_CONFIG_ID, (Object)defaultLootTable));
        }
        return lootTables;
    }

    @NotNull
    private Map<class_2960, LooniumStructureConfiguration> determineStructureConfigs(@NotNull ConfigDataManager configData, @NotNull Object2BooleanMap<class_2960> structures) {
        if (this.configOverride != null) {
            LooniumStructureConfiguration overrideConfig = configData.getEffectiveLooniumStructureConfiguration(this.configOverride);
            return Map.of(LooniumStructureConfiguration.DEFAULT_CONFIG_ID, overrideConfig != null ? overrideConfig : LooniumBlockEntity.getDefaultConfig(configData));
        }
        LooniumStructureConfiguration defaultConfig = LooniumBlockEntity.getDefaultConfig(configData);
        HashMap<class_2960, LooniumStructureConfiguration> structureConfigs = new HashMap<class_2960, LooniumStructureConfiguration>();
        for (Object2BooleanMap.Entry structureEntry : structures.object2BooleanEntrySet()) {
            LooniumStructureConfiguration structureSpecificConfig = configData.getEffectiveLooniumStructureConfiguration((class_2960)structureEntry.getKey());
            LooniumStructureConfiguration structureConfig = structureSpecificConfig != null ? structureSpecificConfig : defaultConfig;
            if (structureConfig == null || !structureEntry.getBooleanValue() && structureConfig.boundingBoxType != class_7061.class_7062.field_37200) continue;
            structureConfigs.put((class_2960)structureEntry.getKey(), structureConfig);
        }
        structureConfigs.put(LooniumStructureConfiguration.DEFAULT_CONFIG_ID, defaultConfig);
        return structureConfigs;
    }

    private static LooniumStructureConfiguration getDefaultConfig(ConfigDataManager configData) {
        LooniumStructureConfiguration defaultConfig = configData.getEffectiveLooniumStructureConfiguration(LooniumStructureConfiguration.DEFAULT_CONFIG_ID);
        return defaultConfig != null ? defaultConfig : FALLBACK_CONFIG.get();
    }

    private void detectStructure(class_3218 world) {
        Object2BooleanRBTreeMap structureMap = new Object2BooleanRBTreeMap();
        class_5138 structureManager = world.method_27056();
        class_2338 pos = this.method_11016();
        Map structures = structureManager.method_41037(pos);
        for (Map.Entry entry : structures.entrySet()) {
            class_3195 structure = (class_3195)entry.getKey();
            class_3449 start = structureManager.method_28388(pos, structure);
            if (!start.method_16657()) continue;
            class_2960 structureId = world.method_30349().method_30530(class_7924.field_41246).method_10221((Object)structure);
            boolean insidePiece = structureManager.method_41033(pos, start);
            if (!insidePiece && structureMap.getBoolean((Object)structureId)) continue;
            structureMap.put((Object)structureId, insidePiece);
        }
        this.detectedStructures = new Object2BooleanArrayMap((Object2BooleanMap)structureMap);
        this.method_5431();
        this.sync();
    }

    @Override
    public int getColor() {
        return 12754274;
    }

    @Override
    public int getMaxMana() {
        return 35000;
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 5);
    }

    @Override
    public RadiusDescriptor getSecondaryRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 9);
    }

    @Override
    public void readFromPacketNBT(class_2487 cmp) {
        super.readFromPacketNBT(cmp);
        if (cmp.method_10545(TAG_LOOT_TABLE)) {
            this.lootTableOverride = new class_2960(cmp.method_10558(TAG_LOOT_TABLE));
        }
        if (cmp.method_10545(TAG_CONFIG_OVERRIDE)) {
            this.configOverride = new class_2960(cmp.method_10558(TAG_CONFIG_OVERRIDE));
        }
        if (cmp.method_10545(TAG_ATTUNE_DISPLAY_OVERRIDE)) {
            this.attuneDisplayOverride = cmp.method_10558(TAG_ATTUNE_DISPLAY_OVERRIDE);
        }
        if (cmp.method_10545(TAG_DETECTED_STRUCTURE)) {
            String rawString = cmp.method_10558(TAG_DETECTED_STRUCTURE);
            if (rawString.isEmpty()) {
                this.detectedStructures = Object2BooleanMaps.emptyMap();
            } else {
                List<ObjectBooleanPair> structureList = Arrays.stream(rawString.split(",")).map(part -> {
                    if (part.contains("|")) {
                        String[] components = part.split("\\|", 2);
                        return ObjectBooleanPair.of((Object)new class_2960(components[0]), (boolean)Boolean.parseBoolean(components[1]));
                    }
                    return ObjectBooleanPair.of((Object)new class_2960(part), (boolean)false);
                }).toList();
                Object2BooleanArrayMap map = new Object2BooleanArrayMap(structureList.size());
                structureList.forEach(entry -> map.put((Object)((class_2960)entry.key()), entry.valueBoolean()));
                this.detectedStructures = map;
            }
        }
    }

    @Override
    public void writeToPacketNBT(class_2487 cmp) {
        super.writeToPacketNBT(cmp);
        if (this.lootTableOverride != null) {
            cmp.method_10582(TAG_LOOT_TABLE, this.lootTableOverride.toString());
        }
        if (this.configOverride != null) {
            cmp.method_10582(TAG_CONFIG_OVERRIDE, this.configOverride.toString());
        }
        if (this.attuneDisplayOverride != null) {
            cmp.method_10582(TAG_ATTUNE_DISPLAY_OVERRIDE, this.attuneDisplayOverride);
        }
        if (this.detectedStructures != null) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean first = true;
            for (Object2BooleanMap.Entry entry : this.detectedStructures.object2BooleanEntrySet()) {
                if (first) {
                    first = false;
                } else {
                    stringBuilder.append(',');
                }
                stringBuilder.append(entry.getKey()).append('|').append(entry.getBooleanValue());
            }
            cmp.method_10582(TAG_DETECTED_STRUCTURE, stringBuilder.toString());
        }
    }

    public static void dropLooniumItems(class_1309 living, Consumer<class_1799> consumer) {
        LooniumComponent comp = XplatAbstractions.INSTANCE.looniumComponent(living);
        if (comp != null && comp.isOverrideDrop()) {
            consumer.accept(comp.getDrop());
        }
    }

    public static class WandHud
    extends BindableSpecialFlowerBlockEntity.BindableFlowerWandHud<LooniumBlockEntity> {
        public WandHud(LooniumBlockEntity flower) {
            super(flower);
        }

        @Override
        public void renderHUD(class_332 gui, class_310 mc) {
            String lootType;
            String structureName = "";
            if (((LooniumBlockEntity)this.flower).attuneDisplayOverride != null) {
                lootType = ((LooniumBlockEntity)this.flower).attuneDisplayOverride;
            } else if (((LooniumBlockEntity)this.flower).lootTableOverride != null) {
                lootType = "attuned";
            } else if (((LooniumBlockEntity)this.flower).detectedStructures == null || ((LooniumBlockEntity)this.flower).detectedStructures.isEmpty()) {
                lootType = "not_attuned";
            } else if (((LooniumBlockEntity)this.flower).detectedStructures.size() == 1) {
                lootType = "attuned_one";
                structureName = ((LooniumBlockEntity)this.flower).detectedStructures.keySet().stream().findFirst().map(rl -> class_1074.method_4662((String)("structure." + rl.method_12836() + "." + rl.method_12832().replace("/", ".")), (Object[])new Object[0])).orElseGet(() -> "");
            } else {
                lootType = "attuned_many";
            }
            String lootTypeMessage = class_1074.method_4662((String)("botaniamisc.loonium." + lootType), (Object[])new Object[]{structureName});
            int lootTypeWidth = mc.field_1772.method_1727(lootTypeMessage);
            int lootTypeTextStart = (mc.method_22683().method_4486() - lootTypeWidth) / 2;
            int halfMinWidth = (lootTypeWidth + 4) / 2;
            int centerY = mc.method_22683().method_4502() / 2;
            super.renderHUD(gui, mc, halfMinWidth, halfMinWidth, 40);
            gui.method_25303(mc.field_1772, lootTypeMessage, lootTypeTextStart, centerY + 30, ((LooniumBlockEntity)this.flower).getColor());
        }
    }
}

