/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.block_entity;

import java.util.Objects;
import net.minecraft.class_1074;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.block.Bound;
import vazkii.botania.api.block.WandBindable;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.block_entity.SpecialFlowerBlockEntity;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.helper.MathHelper;
import vazkii.botania.common.item.BotaniaItems;

public abstract class BindableSpecialFlowerBlockEntity<T>
extends SpecialFlowerBlockEntity
implements WandBindable {
    private final Class<T> bindClass;
    @Nullable
    protected class_2338 bindingPos = null;
    private static final String TAG_BINDING = "binding";

    public BindableSpecialFlowerBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state, Class<T> bindClass) {
        super(type, pos, state);
        this.bindClass = bindClass;
    }

    public abstract int getBindingRadius();

    @Nullable
    public abstract class_2338 findClosestTarget();

    @Override
    protected void tickFlower() {
        super.tickFlower();
        if (Bound.UNBOUND_POS.equals((Object)this.bindingPos)) {
            this.setBindingPos(null);
        } else if (!(this.ticksExisted != 1 || this.field_11863.field_9236 || this.bindingPos != null && this.isValidBinding())) {
            this.setBindingPos(this.findClosestTarget());
        }
    }

    @Override
    public void setPlacedBy(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        if (placer != null && placer.method_24518(BotaniaItems.obedienceStick)) {
            this.setBindingPos(Bound.UNBOUND_POS);
        }
        super.setPlacedBy(level, pos, state, placer, stack);
    }

    @Nullable
    public class_2338 getBindingPos() {
        return this.bindingPos;
    }

    public void setBindingPos(@Nullable class_2338 bindingPos) {
        boolean changed = !Objects.equals(this.bindingPos, bindingPos);
        this.bindingPos = bindingPos;
        if (changed) {
            this.method_5431();
            this.sync();
        }
    }

    @Nullable
    public T findBindCandidateAt(class_2338 pos) {
        if (this.field_11863 == null || pos == null) {
            return null;
        }
        class_2586 be = this.field_11863.method_8321(pos);
        return this.bindClass.isInstance(be) ? (T)this.bindClass.cast(be) : null;
    }

    @Nullable
    public T findBoundTile() {
        return this.findBindCandidateAt(this.bindingPos);
    }

    public boolean wouldBeValidBinding(@Nullable class_2338 pos) {
        if (this.field_11863 == null || pos == null || !this.field_11863.method_8477(pos) || MathHelper.distSqr((class_2382)this.method_11016(), (class_2382)pos) > (long)this.getBindingRadius() * (long)this.getBindingRadius()) {
            return false;
        }
        return this.findBindCandidateAt(pos) != null;
    }

    public boolean isValidBinding() {
        return this.wouldBeValidBinding(this.bindingPos);
    }

    @Override
    public class_2338 getBinding() {
        return this.isValidBinding() ? this.bindingPos : null;
    }

    @Override
    public boolean canSelect(class_1657 player, class_1799 wand, class_2338 pos, class_2350 side) {
        return true;
    }

    @Override
    public boolean bindTo(class_1657 player, class_1799 wand, class_2338 pos, class_2350 side) {
        if (this.wouldBeValidBinding(pos)) {
            this.setBindingPos(pos);
            return true;
        }
        return false;
    }

    @Override
    public void writeToPacketNBT(class_2487 cmp) {
        super.writeToPacketNBT(cmp);
        if (this.bindingPos != null) {
            cmp.method_10566(TAG_BINDING, (class_2520)class_2512.method_10692((class_2338)this.bindingPos));
        }
    }

    @Override
    public void readFromPacketNBT(class_2487 cmp) {
        super.readFromPacketNBT(cmp);
        if (cmp.method_10545(TAG_BINDING)) {
            this.bindingPos = class_2512.method_10691((class_2487)cmp.method_10562(TAG_BINDING));
        } else {
            if (cmp.method_10545("collectorX")) {
                this.bindingPos = new class_2338(cmp.method_10550("collectorX"), cmp.method_10550("collectorY"), cmp.method_10550("collectorZ"));
            } else if (cmp.method_10545("poolX")) {
                this.bindingPos = new class_2338(cmp.method_10550("poolX"), cmp.method_10550("poolY"), cmp.method_10550("poolZ"));
            }
            if (this.bindingPos != null && this.bindingPos.method_10264() == -1) {
                this.bindingPos = null;
            }
        }
    }

    public abstract int getMana();

    public abstract void addMana(int var1);

    public abstract int getMaxMana();

    public abstract int getColor();

    public abstract class_1799 getDefaultHudIcon();

    public class_1799 getHudIcon() {
        T boundTile = this.findBoundTile();
        if (boundTile != null) {
            return new class_1799((class_1935)((class_2586)boundTile).method_11010().method_26204().method_8389());
        }
        return this.getDefaultHudIcon();
    }

    public static class BindableFlowerWandHud<F extends BindableSpecialFlowerBlockEntity<?>>
    implements WandHUD {
        protected final F flower;

        public BindableFlowerWandHud(F flower) {
            this.flower = flower;
        }

        public void renderHUD(class_332 gui, class_310 mc, int minLeft, int minRight, int minDown) {
            String name = class_1074.method_4662((String)this.flower.method_11010().method_26204().method_9539(), (Object[])new Object[0]);
            int color = ((BindableSpecialFlowerBlockEntity)this.flower).getColor();
            int centerX = mc.method_22683().method_4486() / 2;
            int centerY = mc.method_22683().method_4502() / 2;
            int left = (Math.max(102, mc.field_1772.method_1727(name)) + 4) / 2;
            int right = left + 20;
            left = Math.max(left, minLeft);
            right = Math.max(right, minRight);
            RenderHelper.renderHUDBox(gui, centerX - left, centerY + 8, centerX + right, centerY + Math.max(30, minDown));
            BotaniaAPIClient.instance().drawComplexManaHUD(gui, color, ((BindableSpecialFlowerBlockEntity)this.flower).getMana(), ((BindableSpecialFlowerBlockEntity)this.flower).getMaxMana(), name, ((BindableSpecialFlowerBlockEntity)this.flower).getHudIcon(), ((BindableSpecialFlowerBlockEntity)this.flower).isValidBinding());
        }

        @Override
        public void renderHUD(class_332 gui, class_310 mc) {
            this.renderHUD(gui, mc, 0, 0, 0);
        }
    }
}

