/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.impl;

import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_7923;
import net.minecraft.world.item.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.BotaniaRegistries;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.configdata.ConfigDataManager;
import vazkii.botania.api.corporea.CorporeaNodeDetector;
import vazkii.botania.api.internal.ManaNetwork;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.flower.functional.SolegnoliaBlockEntity;
import vazkii.botania.common.config.ConfigDataManagerImpl;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.handler.ManaNetworkHandler;
import vazkii.botania.common.integration.corporea.CorporeaNodeDetectors;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.relic.RingOfLokiItem;

import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;

public class BotaniaAPIImpl implements BotaniaAPI {

	private enum ArmorMaterial implements net.minecraft.class_1741 {
		MANASTEEL("manasteel", 16,
				Map.of(
						class_1738.class_8051.field_41937, 2,
						class_1738.class_8051.field_41936, 5,
						class_1738.class_8051.field_41935, 6,
						class_1738.class_8051.field_41934, 2
				),
				18, () -> BotaniaSounds.equipManasteel, () -> BotaniaItems.manaSteel, 0),
		MANAWEAVE("manaweave", 5,
				Map.of(
						class_1738.class_8051.field_41937, 1,
						class_1738.class_8051.field_41936, 2,
						class_1738.class_8051.field_41935, 3,
						class_1738.class_8051.field_41934, 1
				),
				18, () -> BotaniaSounds.equipManaweave, () -> BotaniaItems.manaweaveCloth, 0),
		ELEMENTIUM("elementium", 18,
				Map.of(
						class_1738.class_8051.field_41937, 2,
						class_1738.class_8051.field_41936, 5,
						class_1738.class_8051.field_41935, 6,
						class_1738.class_8051.field_41934, 2
				),
				18, () -> BotaniaSounds.equipElementium, () -> BotaniaItems.elementium, 0),
		TERRASTEEL("terrasteel", 34,
				Map.of(
						class_1738.class_8051.field_41937, 3,
						class_1738.class_8051.field_41936, 6,
						class_1738.class_8051.field_41935, 8,
						class_1738.class_8051.field_41934, 3
				),
				26, () -> BotaniaSounds.equipTerrasteel, () -> BotaniaItems.terrasteel, 3);

		private final String name;
		private final int durabilityMultiplier;
		private final Map<class_1738.class_8051, Integer> damageReduction;
		private final int enchantability;
		private final Supplier<class_3414> equipSound;
		private final Supplier<class_1792> repairItem;
		private final float toughness;

		ArmorMaterial(String name, int durabilityMultiplier, Map<class_1738.class_8051, Integer> damageReduction,
				int enchantability, Supplier<class_3414> equipSound, Supplier<class_1792> repairItem, float toughness) {
			this.name = name;
			this.durabilityMultiplier = durabilityMultiplier;
			this.damageReduction = damageReduction;
			this.enchantability = enchantability;
			this.equipSound = equipSound;
			this.repairItem = repairItem;
			this.toughness = toughness;
		}

		@Override
		public int method_48402(class_1738.class_8051 slot) {
			// [VanillaCopy] ArmorMaterials
			int base = switch (slot) {
				case field_41937 -> 13;
				case field_41936 -> 15;
				case field_41935 -> 16;
				case field_41934 -> 11;
			};
			return durabilityMultiplier * base;
		}

		@Override
		public int method_48403(class_1738.class_8051 slot) {
			return this.damageReduction.get(slot);
		}

		@Override
		public int method_7699() {
			return enchantability;
		}

		@NotNull
		@Override
		public class_3414 method_7698() {
			return equipSound.get();
		}

		@NotNull
		@Override
		public class_1856 method_7695() {
			return class_1856.method_8091(repairItem.get());
		}

		@NotNull
		@Override
		public String method_7694() {
			return name;
		}

		@Override
		public float method_7700() {
			return toughness;
		}

		@Override
		public float method_24355() {
			return 0;
		}
	}

	private enum ItemTier implements class_1832 {
		MANASTEEL(300, 6.2F, 2, 3, 20, () -> BotaniaItems.manaSteel),
		ELEMENTIUM(720, 6.2F, 2, 3, 20, () -> BotaniaItems.elementium),
		TERRASTEEL(2300, 9, 4, 4, 26, () -> BotaniaItems.terrasteel);

		private final int maxUses;
		private final float efficiency;
		private final float attackDamage;
		private final int harvestLevel;
		private final int enchantability;
		private final Supplier<class_1792> repairItem;

		ItemTier(int maxUses, float efficiency, float attackDamage, int harvestLevel, int enchantability, Supplier<class_1792> repairItem) {
			this.maxUses = maxUses;
			this.efficiency = efficiency;
			this.attackDamage = attackDamage;
			this.harvestLevel = harvestLevel;
			this.enchantability = enchantability;
			this.repairItem = repairItem;
		}

		@Override
		public int method_8025() {
			return maxUses;
		}

		@Override
		public float method_8027() {
			return efficiency;
		}

		@Override
		public float method_8028() {
			return attackDamage;
		}

		@Override
		public int method_8024() {
			return harvestLevel;
		}

		@Override
		public int method_8026() {
			return enchantability;
		}

		@Override
		public class_1856 method_8023() {
			return class_1856.method_8091(repairItem.get());
		}
	}

	private ConfigDataManager configDataManager = new ConfigDataManagerImpl();

	@Override
	public int apiVersion() {
		return 2;
	}

	@Nullable
	@Override
	@SuppressWarnings("unchecked")
	public class_2378<Brew> getBrewRegistry() {
		return (class_2378<Brew>) class_7923.field_41167.method_10223(BotaniaRegistries.BREWS.method_29177());
	}

	@Override
	public net.minecraft.class_1741 getManasteelArmorMaterial() {
		return ArmorMaterial.MANASTEEL;
	}

	@Override
	public net.minecraft.class_1741 getElementiumArmorMaterial() {
		return ArmorMaterial.ELEMENTIUM;
	}

	@Override
	public net.minecraft.class_1741 getManaweaveArmorMaterial() {
		return ArmorMaterial.MANAWEAVE;
	}

	@Override
	public net.minecraft.class_1741 getTerrasteelArmorMaterial() {
		return ArmorMaterial.TERRASTEEL;
	}

	@Override
	public class_1832 getManasteelItemTier() {
		return ItemTier.MANASTEEL;
	}

	@Override
	public class_1832 getElementiumItemTier() {
		return ItemTier.ELEMENTIUM;
	}

	@Override
	public class_1832 getTerrasteelItemTier() {
		return ItemTier.TERRASTEEL;
	}

	@Override
	public ManaNetwork getManaNetworkInstance() {
		return ManaNetworkHandler.instance;
	}

	@Override
	public class_1263 getAccessoriesInventory(class_1657 player) {
		return EquipmentHandler.getAllWorn(player);
	}

	@Override
	public void breakOnAllCursors(class_1657 player, class_1799 stack, class_2338 pos, class_2350 side) {
		RingOfLokiItem.breakOnAllCursors(player, stack, pos, side);
	}

	@Override
	public boolean hasSolegnoliaAround(class_1297 e) {
		return SolegnoliaBlockEntity.hasSolegnoliaAround(e);
	}

	@Override
	public void sparkleFX(class_1937 world, double x, double y, double z, float r, float g, float b, float size, int m) {
		SparkleParticleData data = SparkleParticleData.sparkle(size, r, g, b, m);
		world.method_8406(data, x, y, z, 0, 0, 0);
	}

	private final Map<class_2960, Function<class_1767, class_2248>> paintableBlocks = new ConcurrentHashMap<>();

	@Override
	public Map<class_2960, Function<class_1767, class_2248>> getPaintableBlocks() {
		return Collections.unmodifiableMap(paintableBlocks);
	}

	@Override
	public void registerPaintableBlock(class_2960 block, Function<class_1767, class_2248> transformer) {
		paintableBlocks.put(block, transformer);
	}

	@Override
	public void registerCorporeaNodeDetector(CorporeaNodeDetector detector) {
		CorporeaNodeDetectors.register(detector);
	}

	@Override
	public ConfigDataManager getConfigData() {
		return configDataManager;
	}

	@Override
	public void setConfigData(ConfigDataManager configDataManager) {
		this.configDataManager = configDataManager;
	}
}
