package vazkii.botania.common.helper;

import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3230;

public class EntityHelper {
	/**
	 * Shrinks the itemstack in an entity and ensures that the new size is sent to clients
	 */
	public static void shrinkItem(class_1542 entity) {
		entity.method_6983().method_7934(1);
		syncItem(entity);
	}

	/**
	 * Forces an item entity to resync its item to the client.
	 *
	 * Entity data only resyncs when the old/new values are not Object.equals().
	 * Since stacks do not implement equals, and we're not changing the actual stack object,
	 * the old/new values are == and thus the game doesn't resync.
	 * We have to set a dummy value then set it back to tell the game to resync.
	 */
	public static void syncItem(class_1542 entity) {
		var save = entity.method_6983();
		entity.method_6979(class_1799.field_8037);
		entity.method_6979(save);
	}

	/**
	 * Adds an infinite-duration effect to a mob or player. The effect is not applied if the target already has the
	 * same effect at a higher level with any duration, or at the same level with infinite duration.
	 */
	public static void addStaticEffect(class_1309 living, class_1291 mobEffect, int amplifier) {
		class_1293 effect = living.method_6112(mobEffect);
		if (effect == null || effect.method_5578() < amplifier
				|| effect.method_5578() == amplifier && !effect.method_48559()) {
			living.method_6092(new class_1293(mobEffect, class_1293.field_42106,
					amplifier, false, true, true));
		}
	}

	/**
	 * Replaces an infinite-duration effect on a mob or player with a finite-duration version of itself.
	 * The effect is only replaced if it has the expected level and infinite duration.
	 */
	public static void convertStaticEffectToFinite(class_1309 living, class_1291 mobEffect, int expectedAmplifier, int duration) {
		class_1293 effect = living.method_6112(mobEffect);
		if (effect != null && effect.method_5578() == expectedAmplifier && effect.method_48559()) {
			living.method_6016(mobEffect);
			living.method_6092(new class_1293(mobEffect, duration, expectedAmplifier, false, true, true));
		}
	}

	/**
	 * Removes an infinite-duration effect from a mob or player.
	 * The effect is only removed if it has the expected level and infinite duration.
	 */
	public static void removeStaticEffect(class_1309 living, class_1291 mobEffect, int expectedAmplifier) {
		class_1293 effect = living.method_6112(mobEffect);
		if (effect != null && effect.method_5578() == expectedAmplifier && effect.method_48559()) {
			living.method_6016(mobEffect);
		}
	}

	/**
	 * Creates a "post-teleport" chunk loading ticket for the specified entity if it is located at least two chunks
	 * away from the specified source position in one of the cardinal directions.
	 * The post-teleport ticket only keeps the target chunk loaded for a bit to potentially reduce loading/unloading
	 * related lag spikes, but does not necessarily make the target chunk entity-/redstone-processing.
	 */
	public static void addTeleportTicketIfFarAway(class_1297 entity, class_2338 sourcePos) {
		class_1923 entityChunk = new class_1923(entity.method_24515());
		class_1923 sourceChunk = new class_1923(sourcePos);
		if (entity.method_37908() instanceof class_3218 serverLevel && entityChunk.method_24022(sourceChunk) > 2) {
			serverLevel.method_14178().method_17297(class_3230.field_19347, entityChunk, 0, entity.method_5628());
		}
	}
}
