/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.api.recipe;

import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_5819;

/**
 * A basic interface for inputs and outputs for in-world blocks.
 */
public interface StateIngredient extends Predicate<class_2680> {
	@Override
	boolean test(class_2680 state);

	class_2680 pick(class_5819 random);

	JsonObject serialize();

	void write(class_2540 buffer);

	List<class_1799> getDisplayedStacks();

	/** A description tooltip to display in areas like JEI recipes. */
	default List<class_2561> descriptionTooltip() {
		return Collections.emptyList();
	}

	List<class_2680> getDisplayed();
}
