/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.api.item;

import net.minecraft.class_1799;

/**
 * An item that implements this can have Ancient Wills
 * crafted onto it.
 */
public interface AncientWillContainer {
	enum AncientWillType {
		AHRIM,
		DHAROK,
		GUTHAN,
		TORAG,
		VERAC,
		KARIL
	}

	void addAncientWill(class_1799 stack, AncientWillType will);

	boolean hasAncientWill(class_1799 stack, AncientWillType will);

}
