/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.internal_caps.KeptItemsComponent;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;

public class ResoluteIvyItem extends class_1792 {

	public static final String TAG_KEEP = "Botania_keepIvy";

	public static final String TAG_PLAYER_KEPT_DROPS = "Botania_playerKeptDrops";
	private static final String TAG_DROP_COUNT = "dropCount";
	private static final String TAG_DROP_PREFIX = "dropPrefix";

	public ResoluteIvyItem(class_1793 props) {
		super(props);
	}

	public static boolean hasIvy(class_1799 stack) {
		return !stack.method_7960() && stack.method_7985() && ItemNBTHelper.getBoolean(stack, TAG_KEEP, false);
	}

	// Accessories are handled in the integration code
	public static void keepDropsOnDeath(class_1657 player) {
		List<class_1799> keeps = new ArrayList<>();
		for (int i = 0; i < player.method_31548().method_5439(); i++) {
			class_1799 stack = player.method_31548().method_5438(i);
			if (!stack.method_7960() && stack.method_7985() && ItemNBTHelper.getBoolean(stack, TAG_KEEP, false)) {
				keeps.add(stack);
				player.method_31548().method_5447(i, class_1799.field_8037);
			}
		}

		// The capabilities are not yet invalidated at this point, no need to do reviveCaps
		KeptItemsComponent data = XplatAbstractions.INSTANCE.keptItemsComponent(player, false);
		data.addAll(keeps);
	}

	public static void onPlayerRespawn(class_1657 oldPlayer, class_1657 newPlayer, boolean alive) {
		if (!alive) {
			// At this point, the Forge capabilities have been invalidated and are no longer
			// accessible unless we do a hacky reviveCaps() call, see ForgeXplatImpl for details.
			KeptItemsComponent keeps = XplatAbstractions.INSTANCE.keptItemsComponent(oldPlayer, true);

			for (class_1799 stack : keeps.getStacks()) {
				class_1799 copy = stack.method_7972();
				copy.method_7983(TAG_KEEP);
				if (!newPlayer.method_31548().method_7394(copy)) {
					newPlayer.method_5775(copy);
				}
			}
		}
	}

}
