/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.mana;

import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_5558;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.common.block.BotaniaWaterloggedBlock;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.TerrestrialAgglomerationPlateBlockEntity;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.mixin.RecipeManagerAccessor;

public class TerrestrialAgglomerationPlateBlock extends BotaniaWaterloggedBlock implements class_2343 {

	private static final class_265 SHAPE = method_9541(0, 0, 0, 16, 3, 16);

	public TerrestrialAgglomerationPlateBlock(class_2251 builder) {
		super(builder);
	}

	@NotNull
	@Override
	public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
		return SHAPE;
	}

	@Override
	public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
		class_1799 stack = player.method_5998(hand);
		if (!stack.method_7960() && usesItem(stack, world)) {
			if (!world.field_9236) {
				class_1799 target = stack.method_7971(1);
				class_1542 item = new class_1542(world, pos.method_10263() + 0.5, pos.method_10264() + 0.5, pos.method_10260() + 0.5, target);
				item.method_6982(40);
				item.method_18799(class_243.field_1353);
				world.method_8649(item);
			}

			return class_1269.method_29236(world.method_8608());
		}

		return class_1269.field_5811;
	}

	private static boolean usesItem(class_1799 stack, class_1937 world) {
		for (class_1860<?> value : ((RecipeManagerAccessor) world.method_8433()).botania_getAll(BotaniaRecipeTypes.TERRA_PLATE_TYPE).values()) {
			for (class_1856 i : value.method_8117()) {
				if (i.method_8093(stack)) {
					return true;
				}
			}
		}
		return false;
	}

	@Override
	public boolean method_9516(@NotNull class_2680 state, @NotNull class_1922 world, @NotNull class_2338 pos, class_10 type) {
		return false;
	}

	@NotNull
	@Override
	public class_2586 method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
		return new TerrestrialAgglomerationPlateBlockEntity(pos, state);
	}

	@Nullable
	@Override
	public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
		if (!level.field_9236) {
			return createTickerHelper(type, BotaniaBlockEntities.TERRA_PLATE, TerrestrialAgglomerationPlateBlockEntity::serverTick);
		}
		return null;
	}

	@Override
	public boolean method_9498(class_2680 state) {
		return true;
	}

	@Override
	public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
		TerrestrialAgglomerationPlateBlockEntity plate = (TerrestrialAgglomerationPlateBlockEntity) world.method_8321(pos);
		return plate.getComparatorLevel();
	}

}
