/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import vazkii.botania.common.lib.LibMisc;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_2582;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public final class BotaniaBannerPatterns {
	private static final List<class_2582> ALL = new ArrayList<>();
	public static final class_5321<class_2582> FLOWER = make("flower");
	public static final class_5321<class_2582> LEXICON = make("lexicon");
	public static final class_5321<class_2582> LOGO = make("logo");
	public static final class_5321<class_2582> SAPLING = make("sapling");
	public static final class_5321<class_2582> TINY_POTATO = make("tiny_potato");
	public static final class_5321<class_2582> SPARK_DISPERSIVE = make("spark_dispersive");
	public static final class_5321<class_2582> SPARK_DOMINANT = make("spark_dominant");
	public static final class_5321<class_2582> SPARK_RECESSIVE = make("spark_recessive");
	public static final class_5321<class_2582> SPARK_ISOLATED = make("spark_isolated");

	public static final class_5321<class_2582> FISH = make("fish");
	public static final class_5321<class_2582> AXE = make("axe");
	public static final class_5321<class_2582> HOE = make("hoe");
	public static final class_5321<class_2582> PICKAXE = make("pickaxe");
	public static final class_5321<class_2582> SHOVEL = make("shovel");
	public static final class_5321<class_2582> SWORD = make("sword");

	private static class_5321<class_2582> make(String hashName) {
		class_2582 pattern = new class_2582(LibMisc.MOD_ID + ":" + hashName);
		ALL.add(pattern);
		return class_5321.method_29179(class_7924.field_41252, prefix(hashName));
	}

	public static void submitRegistrations(BiConsumer<class_2582, class_2960> consumer) {
		for (var pattern : ALL) {
			consumer.accept(pattern, new class_2960(pattern.method_10945()));
		}
	}
}
