/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.armor.manasteel;

import com.google.common.base.Suppliers;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.PhantomInkable;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.gui.TooltipHandler;
import vazkii.botania.client.lib.ResourcesLib;
import vazkii.botania.common.annotations.SoftImplement;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.CustomDamageItem;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.proxy.Proxy;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class ManasteelArmorItem extends class_1738 implements CustomDamageItem, PhantomInkable {

	private static final String TAG_PHANTOM_INK = "phantomInk";

	public final class_8051 field_41933;

	public ManasteelArmorItem(class_8051 type, class_1793 props) {
		this(type, BotaniaAPI.instance().getManasteelArmorMaterial(), props);
	}

	public ManasteelArmorItem(class_8051 type, class_1741 mat, class_1793 props) {
		super(mat, type, props);
		this.field_41933 = type;
	}

	@Override
	public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
		if (entity instanceof class_1657 player) {
			if (!world.field_9236 && stack.method_7919() > 0 && ManaItemHandler.instance().requestManaExact(stack, player, getManaPerDamage() * 2, true)) {
				stack.method_7974(stack.method_7919() - 1);
			}
		}
	}

	@Override
	public <T extends class_1309> int damageItem(class_1799 stack, int amount, T entity, Consumer<T> onBroken) {
		return ToolCommons.damageItemIfPossible(stack, amount, entity, getManaPerDamage());
	}

	protected int getManaPerDamage() {
		return 70;
	}

	@SoftImplement("IForgeItem")
	@NotNull
	public final String getArmorTexture(class_1799 stack, class_1297 entity, class_1304 slot, String type) {
		return hasPhantomInk(stack) ? ResourcesLib.MODEL_INVISIBLE_ARMOR : getArmorTextureAfterInk(stack, slot);
	}

	public String getArmorTextureAfterInk(class_1799 stack, class_1304 slot) {
		return ResourcesLib.MODEL_MANASTEEL_NEW;
	}

	@Override
	public void method_7851(class_1799 stack, class_1937 world, List<class_2561> list, class_1836 flags) {
		TooltipHandler.addOnShift(list, () -> addInformationAfterShift(stack, world, list, flags));
	}

	public void addInformationAfterShift(class_1799 stack, class_1937 world, List<class_2561> list, class_1836 flags) {
		class_1657 player = Proxy.INSTANCE.getClientPlayer();
		list.add(getArmorSetTitle(player));
		addArmorSetDescription(stack, list);
		class_1799[] stacks = getArmorSetStacks();
		for (class_1799 armor : stacks) {
			class_5250 cmp = class_2561.method_43470(" - ").method_10852(armor.method_7964());
			class_1304 slot = ((class_1738) armor.method_7909()).method_7685();
			cmp.method_27692(hasArmorSetItem(player, slot) ? class_124.field_1060 : class_124.field_1080);
			list.add(cmp);
		}
		if (hasPhantomInk(stack)) {
			list.add(class_2561.method_43471("botaniamisc.hasPhantomInk").method_27692(class_124.field_1080));
		}
	}

	private static final Supplier<class_1799[]> armorSet = Suppliers.memoize(() -> new class_1799[] {
			new class_1799(BotaniaItems.manasteelHelm),
			new class_1799(BotaniaItems.manasteelChest),
			new class_1799(BotaniaItems.manasteelLegs),
			new class_1799(BotaniaItems.manasteelBoots)
	});

	public class_1799[] getArmorSetStacks() {
		return armorSet.get();
	}

	public boolean hasArmorSet(class_1657 player) {
		return hasArmorSetItem(player, class_1304.field_6169) && hasArmorSetItem(player, class_1304.field_6174) && hasArmorSetItem(player, class_1304.field_6172) && hasArmorSetItem(player, class_1304.field_6166);
	}

	public boolean hasArmorSetItem(class_1657 player, class_1304 slot) {
		if (player == null || player.method_31548() == null || player.method_31548().field_7548 == null) {
			return false;
		}

		class_1799 stack = player.method_6118(slot);
		if (stack.method_7960()) {
			return false;
		}

		return switch (slot) {
			case field_6169 -> stack.method_31574(BotaniaItems.manasteelHelm);
			case field_6174 -> stack.method_31574(BotaniaItems.manasteelChest);
			case field_6172 -> stack.method_31574(BotaniaItems.manasteelLegs);
			case field_6166 -> stack.method_31574(BotaniaItems.manasteelBoots);
			default -> false;
		};

	}

	private int getSetPiecesEquipped(class_1657 player) {
		int pieces = 0;
		for (class_1304 slot : class_1304.values()) {
			if (slot.method_5925() == class_1304.class_1305.field_6178 && hasArmorSetItem(player, slot)) {
				pieces++;
			}
		}

		return pieces;
	}

	public class_5250 getArmorSetName() {
		return class_2561.method_43471("botania.armorset.manasteel.name");
	}

	private class_2561 getArmorSetTitle(class_1657 player) {
		class_2561 end = getArmorSetName()
				.method_27693(" (" + getSetPiecesEquipped(player) + "/" + getArmorSetStacks().length + ")")
				.method_27692(class_124.field_1080);
		return class_2561.method_43471("botaniamisc.armorset")
				.method_27693(" ")
				.method_10852(end);
	}

	public void addArmorSetDescription(class_1799 stack, List<class_2561> list) {
		list.add(class_2561.method_43471("botania.armorset.manasteel.desc").method_27692(class_124.field_1080));
	}

	@Override
	public boolean hasPhantomInk(class_1799 stack) {
		return ItemNBTHelper.getBoolean(stack, TAG_PHANTOM_INK, false);
	}

	@Override
	public void setPhantomInk(class_1799 stack, boolean ink) {
		ItemNBTHelper.setBoolean(stack, TAG_PHANTOM_INK, ink);
	}
}
