/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import net.minecraft.class_1269;
import net.minecraft.class_1792;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.state.BotaniaStateProperties;
import vazkii.botania.api.state.enums.CraftyCratePattern;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.CraftyCrateBlockEntity;

public class CraftingPatternItem extends class_1792 {
	public final CraftyCratePattern pattern;

	public CraftingPatternItem(CraftyCratePattern pattern, class_1793 props) {
		super(props);
		this.pattern = pattern;
	}

	@NotNull
	@Override
	public class_1269 method_7884(class_1838 ctx) {
		class_1937 world = ctx.method_8045();
		class_2338 pos = ctx.method_8037();
		class_2680 state = world.method_8320(pos);

		if (state.method_27852(BotaniaBlocks.craftCrate)) {
			if (pattern != state.method_11654(BotaniaStateProperties.CRATE_PATTERN)) {
				world.method_8501(pos, state.method_11657(BotaniaStateProperties.CRATE_PATTERN, this.pattern));
				if (!world.field_9236) {
					world.method_35230(pos, BotaniaBlockEntities.CRAFT_CRATE)
							.ifPresent(CraftyCrateBlockEntity::ejectLocked);
				}
				return class_1269.method_29236(world.method_8608());
			}
		}

		return class_1269.field_5811;
	}
}
