/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.model;

import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_583;
import net.minecraft.class_630;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.entity.PixieEntity;

public class PixieModel extends class_583<PixieEntity> {
	private final class_630 body;
	private final class_630 leftWingT;
	private final class_630 leftWingB;
	private final class_630 rightWingT;
	private final class_630 rightWingB;

	private static boolean evil = false;

	private static class_1921 pixieLayer(class_2960 texture) {
		return evil ? RenderHelper.getDopplegangerLayer(texture)
				: class_1921.method_23578(texture);
	}

	public PixieModel(class_630 root) {
		super(PixieModel::pixieLayer);

		body = root.method_32086("body");
		leftWingT = root.method_32086("leftWingT");
		leftWingB = root.method_32086("leftWingB");
		rightWingT = root.method_32086("rightWingT");
		rightWingB = root.method_32086("rightWingB");
	}

	public static class_5609 createMesh() {
		var mesh = new class_5609();
		var root = mesh.method_32111();
		root.method_32117("body", class_5606.method_32108().method_32097(-2.5F, 0.0F, -2.5F, 5, 5, 5), class_5603.method_32090(0.0F, 16.0F, 0.0F));
		root.method_32117("leftWingT", class_5606.method_32108().method_32101(0, 4)
				.method_32097(0.0F, -5.0F, 0.0F, 0, 5, 6),
				class_5603.method_32091(2.5F, 18.0F, 0.5F, 0.2618F, 0.5236F, 0.2618F));
		root.method_32117("leftWingB", class_5606.method_32108().method_32101(0, 11)
				.method_32097(0.0F, 0.0F, 0.0F, 0, 3, 4),
				class_5603.method_32091(2.5F, 18.0F, 0.5F, -0.2618F, 0.2618F, -0.2618F));
		root.method_32117("rightWingT", class_5606.method_32108().method_32101(0, 4)
				.method_32097(0.0F, -5.0F, 0.0F, 0, 5, 6),
				class_5603.method_32091(-2.5F, 18.0F, 0.5F, 0.2618F, -0.5236F, -0.2618F));
		root.method_32117("rightWingB", class_5606.method_32108().method_32101(0, 11)
				.method_32097(0.0F, 0.0F, 0.0F, 0, 3, 4),
				class_5603.method_32091(-2.5F, 18.0F, 0.5F, -0.2618F, -0.2618F, 0.2618F));
		return mesh;
	}

	@Override
	public void method_2828(class_4587 ms, class_4588 buffer, int light, int overlay, float red, float green, float blue, float alpha) {
		body.method_22698(ms, buffer, light, overlay);

		leftWingT.method_22698(ms, buffer, light, overlay);
		leftWingB.method_22698(ms, buffer, light, overlay);
		rightWingT.method_22698(ms, buffer, light, overlay);
		rightWingB.method_22698(ms, buffer, light, overlay);
	}

	@Override
	public void setupAnim(PixieEntity entity, float f, float f1, float f2, float f3, float f4) {
		evil = entity.getPixieType() == 1;
		rightWingT.field_3675 = -(class_3532.method_15362(f2 * 1.7F) * (float) Math.PI * 0.5F);
		leftWingT.field_3675 = class_3532.method_15362(f2 * 1.7F) * (float) Math.PI * 0.5F;
		rightWingB.field_3675 = -(class_3532.method_15362(f2 * 1.7F) * (float) Math.PI * 0.25F);
		leftWingB.field_3675 = class_3532.method_15362(f2 * 1.7F) * (float) Math.PI * 0.25F;
	}

}
