package vazkii.botania.client.integration.emi;

import dev.emi.emi.api.stack.EmiIngredient;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.client.integration.shared.OrechidUIHelper;
import vazkii.botania.common.crafting.MarimorphosisRecipe;

import java.util.stream.Stream;
import net.minecraft.class_2561;

public class MarimorphosisEmiRecipe extends OrechidEmiRecipe {
	public MarimorphosisEmiRecipe(
			MarimorphosisRecipe recipe,
			EmiIngredient orechid) {
		super(BotaniaEmiPlugin.MARIMORPHOSIS, recipe, orechid);
	}

	@NotNull
	@Override
	protected Stream<class_2561> getChanceTooltipComponents(double chance) {
		Stream<class_2561> genericChanceTooltipComponents = super.getChanceTooltipComponents(chance);
		Stream<class_2561> biomeChanceTooltipComponents = OrechidUIHelper.getBiomeChanceAndRatioTooltipComponents(chance, recipe);
		return Stream.concat(genericChanceTooltipComponents, biomeChanceTooltipComponents);
	}
}
